/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
abstract class IndexPopulationStressTest {
    private static final IndexProviderDescriptor PROVIDER = new IndexProviderDescriptor("provider", "1.0");
    private static final int THREADS = 50;
    private static final int MAX_BATCH_SIZE = 100;
    private static final int BATCHES_PER_THREAD = 100;
    @Inject
    private RandomRule random;
    @Inject
    PageCache pageCache;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private final boolean hasValues;
    private final Function<RandomValues, Value> valueGenerator;
    private final Function<IndexPopulationStressTest, IndexProvider> providerCreator;
    private IndexDescriptor descriptor;
    private IndexDescriptor descriptor2;
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(1000, 0.2, true);
    private final NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    private IndexPopulator populator;
    private IndexProvider indexProvider;
    private TokenNameLookup tokenNameLookup;
    private boolean prevAccessCheck;

    IndexPopulationStressTest(boolean hasValues, Function<RandomValues, Value> valueGenerator, Function<IndexPopulationStressTest, IndexProvider> providerCreator) {
        this.hasValues = hasValues;
        this.valueGenerator = valueGenerator;
        this.providerCreator = providerCreator;
    }

    IndexDirectoryStructure.Factory directory() {
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)IndexDirectoryStructure.directoriesByProvider((Path)this.testDirectory.homePath()).forProvider(PROVIDER));
    }

    @BeforeEach
    void setup() throws IOException, EntityNotFoundException {
        this.indexProvider = this.providerCreator.apply(this);
        this.tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
        this.descriptor = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withName("index_0").materialise(0L));
        this.descriptor2 = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withName("index_1").materialise(1L));
        this.fs.mkdirs(this.indexProvider.directoryStructure().rootDirectory());
        this.populator = this.indexProvider.getPopulator(this.descriptor, this.samplingConfig, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), (PageCursorTracer)ArgumentMatchers.any(PageCursorTracer.class))).thenThrow(UnsupportedOperationException.class);
        this.prevAccessCheck = UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)false);
    }

    @AfterEach
    void teardown() {
        UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)this.prevAccessCheck);
        if (this.populator != null) {
            this.populator.close(true, PageCursorTracer.NULL);
        }
    }

    @Test
    void stressIt() throws Throwable {
        Race race = new Race();
        AtomicReferenceArray lastBatches = new AtomicReferenceArray(50);
        Generator[] generators = new Generator[50];
        this.populator.create();
        CountDownLatch insertersDone = new CountDownLatch(50);
        ReentrantReadWriteLock updateLock = new ReentrantReadWriteLock(true);
        for (int i = 0; i < 50; ++i) {
            race.addContestant(this.inserter(lastBatches, generators, insertersDone, updateLock, i), 1);
        }
        ArrayList updates = new ArrayList();
        race.addContestant(this.updater(lastBatches, insertersDone, updateLock, updates));
        race.go();
        this.populator.close(true, PageCursorTracer.NULL);
        this.populator = null;
        this.buildReferencePopulatorSingleThreaded(generators, updates);
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.samplingConfig, this.tokenNameLookup);
             IndexAccessor referenceAccessor = this.indexProvider.getOnlineAccessor(this.descriptor2, this.samplingConfig, this.tokenNameLookup);
             IndexReader reader = accessor.newReader();
             IndexReader referenceReader = referenceAccessor.newReader();){
            SimpleNodeValueClient entries = new SimpleNodeValueClient();
            SimpleNodeValueClient referenceEntries = new SimpleNodeValueClient();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)entries, IndexQueryConstraints.unordered((boolean)this.hasValues), new IndexQuery[]{IndexQuery.exists((int)0)});
            referenceReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)referenceEntries, IndexQueryConstraints.unordered((boolean)this.hasValues), new IndexQuery[]{IndexQuery.exists((int)0)});
            while (referenceEntries.next()) {
                Assertions.assertTrue((boolean)entries.next());
                Assertions.assertEquals((long)referenceEntries.reference, (long)entries.reference);
                if (!this.hasValues) continue;
                Assertions.assertEquals((Object)ValueTuple.of((Value[])referenceEntries.values), (Object)ValueTuple.of((Value[])entries.values));
            }
            Assertions.assertFalse((boolean)entries.next());
        }
    }

    private Runnable updater(AtomicReferenceArray<List<? extends IndexEntryUpdate<?>>> lastBatches, CountDownLatch insertersDone, ReadWriteLock updateLock, Collection<IndexEntryUpdate<?>> updates) {
        return Race.throwing(() -> {
            ArrayList<Long> removed = new ArrayList<Long>();
            RandomValues randomValues = RandomValues.create((Random)new Random(this.random.seed() + 50L));
            while (insertersDone.getCount() > 0L) {
                Thread.sleep(10L);
                updateLock.writeLock().lock();
                try {
                    IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor, PageCursorTracer.NULL);
                    try {
                        for (int i = 0; i < 50; ++i) {
                            List batch = (List)lastBatches.get(i);
                            if (batch == null) continue;
                            IndexEntryUpdate update = null;
                            switch (randomValues.nextInt(3)) {
                                case 0: {
                                    if (removed.isEmpty()) break;
                                    Long id = (Long)removed.remove(randomValues.nextInt(removed.size()));
                                    update = IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.valueGenerator.apply(randomValues)});
                                    break;
                                }
                                case 1: {
                                    IndexEntryUpdate removal = (IndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    update = IndexEntryUpdate.remove((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values());
                                    removed.add(removal.getEntityId());
                                    break;
                                }
                                case 2: {
                                    IndexEntryUpdate removal = (IndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    IndexEntryUpdate.change((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values(), (Value[])((Value[])ArrayUtils.toArray((Object[])new Value[]{this.valueGenerator.apply(randomValues)})));
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                            if (update == null) continue;
                            updater.process(update);
                            updates.add(update);
                        }
                    }
                    finally {
                        if (updater == null) continue;
                        updater.close();
                    }
                }
                finally {
                    updateLock.writeLock().unlock();
                }
            }
        });
    }

    private Runnable inserter(AtomicReferenceArray<List<? extends IndexEntryUpdate<?>>> lastBatches, Generator[] generators, CountDownLatch insertersDone, ReadWriteLock updateLock, int slot) {
        int worstCaseEntriesPerThread = 10000;
        return Race.throwing(() -> {
            try {
                Generator generator = generators[slot] = new Generator(100, this.random.seed() + (long)slot, slot * worstCaseEntriesPerThread);
                for (int j = 0; j < 100; ++j) {
                    List<? extends IndexEntryUpdate<?>> batch = generator.batch();
                    updateLock.readLock().lock();
                    try {
                        this.populator.add(batch, PageCursorTracer.NULL);
                    }
                    finally {
                        updateLock.readLock().unlock();
                    }
                    lastBatches.set(slot, batch);
                }
            }
            finally {
                insertersDone.countDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReferencePopulatorSingleThreaded(Generator[] generators, Collection<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        IndexPopulator referencePopulator = this.indexProvider.getPopulator(this.descriptor2, this.samplingConfig, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        referencePopulator.create();
        boolean referenceSuccess = false;
        try {
            for (Generator generator : generators) {
                generator.reset();
                for (int i = 0; i < 100; ++i) {
                    referencePopulator.add(generator.batch(), PageCursorTracer.NULL);
                }
            }
            try (IndexUpdater updater = referencePopulator.newPopulatingUpdater(this.nodePropertyAccessor, PageCursorTracer.NULL);){
                for (IndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            referenceSuccess = true;
        }
        finally {
            referencePopulator.close(referenceSuccess, PageCursorTracer.NULL);
        }
    }

    private class Generator {
        private final int maxBatchSize;
        private final long seed;
        private final long startEntityId;
        private RandomValues randomValues;
        private long nextEntityId;

        Generator(int maxBatchSize, long seed, long startEntityId) {
            this.startEntityId = startEntityId;
            this.nextEntityId = startEntityId;
            this.maxBatchSize = maxBatchSize;
            this.seed = seed;
            this.reset();
        }

        private void reset() {
            this.randomValues = RandomValues.create((Random)new Random(this.seed));
            this.nextEntityId = this.startEntityId;
        }

        List<? extends IndexEntryUpdate<?>> batch() {
            int n = this.randomValues.nextInt(this.maxBatchSize) + 1;
            ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>(n);
            for (int i = 0; i < n; ++i) {
                updates.add(IndexEntryUpdate.add((long)this.nextEntityId++, (SchemaDescriptorSupplier)IndexPopulationStressTest.this.descriptor, (Value[])new Value[]{IndexPopulationStressTest.this.valueGenerator.apply(this.randomValues)}));
            }
            return updates;
        }
    }
}

