/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.rule.PageCacheConfig;
import org.neo4j.values.storable.Values;

abstract class NativeIndexPopulatorTests<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexTestUtil<KEY, VALUE> {
    private static final int LARGE_AMOUNT_OF_UPDATES = 1000;
    static final NodePropertyAccessor null_property_accessor = (nodeId, propertyKeyId, cursorTracer) -> {
        throw new RuntimeException("Did not expect an attempt to go to store");
    };
    NativeIndexPopulator<KEY, VALUE> populator;

    NativeIndexPopulatorTests() {
    }

    @BeforeEach
    void setupPopulator() throws IOException {
        this.populator = this.createPopulator(this.pageCache);
    }

    abstract NativeIndexPopulator<KEY, VALUE> createPopulator(PageCache var1) throws IOException;

    @Test
    void createShouldCreateFile() {
        this.assertFileNotPresent();
        this.populator.create();
        this.assertFilePresent();
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void createShouldClearExistingFile() throws Exception {
        byte[] someBytes = this.fileWithContent();
        this.populator.create();
        try (StoreFileChannel r = this.fs.read(this.indexFiles.getStoreFile());){
            byte[] firstBytes = new byte[someBytes.length];
            r.readAll(ByteBuffer.wrap(firstBytes));
            Assertions.assertNotEquals((Object)someBytes, (Object)firstBytes, (String)"Expected previous file content to have been cleared but was still there");
        }
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void dropShouldDeleteExistingFile() {
        this.populator.create();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropShouldDeleteExistingDirectory() {
        this.populator.create();
        Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getBase()));
        this.populator.drop();
        Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()), (String)"expected drop to delete index base");
    }

    @Test
    void dropShouldSucceedOnNonExistentFile() {
        this.assertFileNotPresent();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void addShouldHandleEmptyCollection() throws Exception {
        this.populator.create();
        List updates = Collections.emptyList();
        this.populator.add(updates, PageCursorTracer.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void addShouldApplyAllUpdatesOnce() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.populator.add(Arrays.asList(updates), PageCursorTracer.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        this.populator.close(true, PageCursorTracer.NULL);
        this.verifyUpdates(updates);
    }

    @Test
    void updaterShouldApplyUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        this.populator.close(true, PageCursorTracer.NULL);
        this.verifyUpdates(updates);
    }

    @Test
    void updaterMustThrowIfProcessAfterClose() throws Exception {
        this.populator.create();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);
        updater.close();
        Assertions.assertThrows(IllegalStateException.class, () -> updater.process(this.valueCreatorUtil.add(1L, Values.of((Object)Long.MAX_VALUE))));
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void shouldApplyInterleavedUpdatesFromAddAndUpdater() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.applyInterleaved(updates, this.populator);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        this.populator.close(true, PageCursorTracer.NULL);
        this.verifyUpdates(updates);
    }

    @Test
    void successfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assertions.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(true, PageCursorTracer.NULL);
        existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        Assertions.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    void successfulCloseMustMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(true, PageCursorTracer.NULL);
        this.assertHeader(InternalIndexState.ONLINE, null, false);
    }

    @Test
    void unsuccessfulCloseMustSucceedWithoutMarkAsFailed() {
        this.populator.create();
        this.populator.close(false, PageCursorTracer.NULL);
    }

    @Test
    void unsuccessfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assertions.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(false, PageCursorTracer.NULL);
        existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        Assertions.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    void unsuccessfulCloseMustNotMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(false, PageCursorTracer.NULL);
        this.assertHeader(InternalIndexState.POPULATING, null, false);
    }

    @Test
    void closeMustWriteFailureMessageAfterMarkedAsFailed() throws Exception {
        this.populator.create();
        String failureMessage = "Fly, you fools!";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, PageCursorTracer.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    void closeMustWriteFailureMessageAfterMarkedAsFailedWithLongMessage() throws Exception {
        this.populator.create();
        String failureMessage = NativeIndexPopulatorTests.longString(this.pageCache.pageSize());
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, PageCursorTracer.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, true);
    }

    @Test
    void successfulCloseMustThrowIfMarkedAsFailed() {
        this.populator.create();
        this.populator.markAsFailed("");
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, PageCursorTracer.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
        this.populator.close(false, PageCursorTracer.NULL);
    }

    @Test
    void shouldApplyLargeAmountOfInterleavedRandomUpdates() throws Exception {
        this.populator.create();
        this.random.reset();
        Random updaterRandom = new Random(this.random.seed());
        Iterator<IndexEntryUpdate<IndexDescriptor>> updates = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int count = this.interleaveLargeAmountOfUpdates(updaterRandom, updates);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        this.populator.close(true, PageCursorTracer.NULL);
        this.random.reset();
        this.verifyUpdates(this.valueCreatorUtil.randomUpdateGenerator(this.random), count);
    }

    @Test
    void dropMustSucceedAfterSuccessfulClose() {
        this.populator.create();
        this.populator.close(true, PageCursorTracer.NULL);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropMustSucceedAfterUnsuccessfulClose() {
        this.populator.create();
        this.populator.close(false, PageCursorTracer.NULL);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropShouldNotFlushContent() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        try (PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)this.fs, PageCacheConfig.config().withTracer((PageCacheTracer)tracer));){
            this.populator = this.createPopulator(pageCache);
            this.populator.create();
            long preDrop = tracer.flushes();
            this.populator.drop();
            long postDrop = tracer.flushes();
            Assertions.assertEquals((long)preDrop, (long)postDrop);
        }
    }

    @Test
    void successfulCloseMustThrowWithoutPriorSuccessfulCreate() {
        this.assertFileNotPresent();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, PageCursorTracer.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    @Test
    void unsuccessfulCloseMustSucceedWithoutSuccessfulPriorCreate() throws Exception {
        this.assertFileNotPresent();
        String failureMessage = "There is no spoon";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, PageCursorTracer.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    void successfulCloseMustThrowAfterDrop() {
        this.populator.create();
        this.populator.drop();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, PageCursorTracer.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    @Test
    void unsuccessfulCloseMustThrowAfterDrop() {
        this.populator.create();
        this.populator.drop();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(false, PageCursorTracer.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    private int interleaveLargeAmountOfUpdates(Random updaterRandom, Iterator<IndexEntryUpdate<IndexDescriptor>> updates) throws IndexEntryConflictException {
        int count = 0;
        for (int i = 0; i < 1000; ++i) {
            if ((double)updaterRandom.nextFloat() < 0.1) {
                try (IndexUpdater indexUpdater = this.populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);){
                    int numberOfUpdaterUpdates = updaterRandom.nextInt(100);
                    for (int j = 0; j < numberOfUpdaterUpdates; ++j) {
                        indexUpdater.process(updates.next());
                        ++count;
                    }
                }
            }
            this.populator.add(Collections.singletonList(updates.next()), PageCursorTracer.NULL);
            ++count;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertHeader(InternalIndexState expectedState, String failureMessage, boolean messageTruncated) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        try (GBPTree ignored = new GBPTreeBuilder(this.pageCache, this.indexFiles.getStoreFile(), (Layout)this.layout).with((Header.Reader)headerReader).build();){
            switch (expectedState) {
                case ONLINE: {
                    Assertions.assertEquals((byte)1, (byte)headerReader.state, (String)"Index was not marked as online when expected not to be.");
                    Assertions.assertNull((Object)headerReader.failureMessage, (String)"Expected failure message to be null when marked as online.");
                    return;
                }
                case FAILED: {
                    Assertions.assertEquals((byte)0, (byte)headerReader.state, (String)"Index was marked as online when expected not to be.");
                    if (messageTruncated) {
                        Assertions.assertTrue((headerReader.failureMessage.length() < failureMessage.length() ? 1 : 0) != 0);
                        Assertions.assertTrue((boolean)failureMessage.startsWith(headerReader.failureMessage));
                        return;
                    } else {
                        Assertions.assertEquals((Object)failureMessage, (Object)headerReader.failureMessage);
                        return;
                    }
                }
                case POPULATING: {
                    Assertions.assertEquals((byte)2, (byte)headerReader.state, (String)"Index was not left as populating when expected to be.");
                    Assertions.assertNull((Object)headerReader.failureMessage, (String)"Expected failure message to be null when marked as populating.");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected index state " + expectedState);
                }
            }
        }
    }

    private static String longString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    private void applyInterleaved(IndexEntryUpdate<IndexDescriptor>[] updates, NativeIndexPopulator<KEY, VALUE> populator) throws IndexEntryConflictException {
        boolean useUpdater = true;
        ArrayList<IndexEntryUpdate<IndexDescriptor>> populatorBatch = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        IndexUpdater updater = populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            if (this.random.nextInt(100) < 20) {
                if (useUpdater) {
                    updater.close();
                    populatorBatch = new ArrayList();
                } else {
                    populator.add(populatorBatch, PageCursorTracer.NULL);
                    updater = populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);
                }
                boolean bl = useUpdater = !useUpdater;
            }
            if (useUpdater) {
                updater.process(update);
                continue;
            }
            populatorBatch.add(update);
        }
        if (useUpdater) {
            updater.close();
        } else {
            populator.add(populatorBatch, PageCursorTracer.NULL);
        }
    }

    private void verifyUpdates(Iterator<IndexEntryUpdate<IndexDescriptor>> indexEntryUpdateIterator, int count) throws IOException {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        for (int i = 0; i < count; ++i) {
            updates[i] = indexEntryUpdateIterator.next();
        }
        this.verifyUpdates(updates);
    }

    private byte[] fileWithContent() throws IOException {
        int size = 1000;
        this.fs.mkdirs(this.indexFiles.getStoreFile().getParent());
        try (StoreFileChannel storeChannel = this.fs.write(this.indexFiles.getStoreFile());){
            byte[] someBytes = new byte[size];
            this.random.nextBytes(someBytes);
            storeChannel.writeAll(ByteBuffer.wrap(someBytes));
            byte[] byArray = someBytes;
            return byArray;
        }
    }
}

