/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTestCases;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.ValueType;

abstract class NativeUniqueIndexPopulatorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulatorTests<KEY, VALUE> {
    private static final IndexDescriptor uniqueDescriptor = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)42, (int[])new int[]{666})).withName("constraint").materialise(0L);
    private final NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory;
    private final ValueType[] typesOfGroup;
    private final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;

    NativeUniqueIndexPopulatorTest(NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory, ValueType[] typesOfGroup, IndexLayoutFactory<KEY, VALUE> indexLayoutFactory) {
        this.populatorFactory = populatorFactory;
        this.typesOfGroup = typesOfGroup;
        this.indexLayoutFactory = indexLayoutFactory;
    }

    @Override
    NativeIndexPopulator<KEY, VALUE> createPopulator(PageCache pageCache) throws IOException {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs).withMonitor(this.monitor).build();
        return this.populatorFactory.create(context, this.indexFiles, this.layout, this.indexDescriptor, this.tokenNameLookup);
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(uniqueDescriptor, this.typesOfGroup, 0.0);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.indexLayoutFactory.create();
    }

    @Test
    void addShouldThrowOnDuplicateValues() {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        Assertions.assertThrows(IndexEntryConflictException.class, () -> {
            this.populator.add(Arrays.asList(updates), PageCursorTracer.NULL);
            this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        });
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void updaterShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, PageCursorTracer.NULL);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            updater.close();
            this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        });
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IndexEntryConflictException.class), (String)e.getMessage());
        this.populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void shouldSampleUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.populator.add(Arrays.asList(updates), PageCursorTracer.NULL);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            this.populator.includeSample(update);
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        IndexSample sample = this.populator.sample(PageCursorTracer.NULL);
        Assertions.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assertions.assertEquals((long)updates.length, (long)sample.uniqueValues());
        Assertions.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true, PageCursorTracer.NULL);
    }
}

