/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
abstract class FusionIndexAccessorTest {
    private static final long INDEX_ID = 0L;
    private static final long ENTITY_ID = 42L;
    private FusionIndexAccessor fusionIndexAccessor;
    private EnumMap<IndexSlot, IndexAccessor> accessors;
    private IndexAccessor[] aliveAccessors;
    private IndexDescriptor indexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{42})).withName("index").materialise(0L);
    private FileSystemAbstraction fs;
    private IndexDirectoryStructure directoryStructure;
    @Inject
    private RandomRule random;
    private final FusionVersion fusionVersion;

    FusionIndexAccessorTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] activeSlots = this.fusionVersion.aliveSlots();
        this.accessors = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.accessors, IndexAccessor.EMPTY);
        this.aliveAccessors = new IndexAccessor[activeSlots.length];
        block4: for (int i = 0; i < activeSlots.length; ++i) {
            IndexAccessor mock;
            this.aliveAccessors[i] = mock = (IndexAccessor)Mockito.mock(IndexAccessor.class);
            switch (activeSlots[i]) {
                case GENERIC: {
                    this.accessors.put(IndexSlot.GENERIC, mock);
                    continue block4;
                }
                case LUCENE: {
                    this.accessors.put(IndexSlot.LUCENE, mock);
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        SlotSelector slotSelector = this.fusionVersion.slotSelector();
        InstanceSelector instanceSelector = new InstanceSelector(this.accessors);
        this.fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)Path.of("storeDir", new String[0])).forProvider(IndexProviderDescriptor.UNDECIDED);
        IndexFiles indexFiles = new IndexFiles(this.fs, this.directoryStructure, this.indexDescriptor.getId());
        this.fusionIndexAccessor = new FusionIndexAccessor(slotSelector, instanceSelector, this.indexDescriptor, indexFiles);
    }

    private void resetMocks() {
        for (IndexAccessor accessor : this.aliveAccessors) {
            Mockito.reset((Object[])new IndexAccessor[]{accessor});
        }
    }

    @Test
    void dropMustDropAll() throws IOException {
        this.fusionIndexAccessor.drop();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor)).drop();
        }
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.directoryStructure.directoryForIndex(0L));
    }

    @Test
    void dropMustThrowIfDropAnyFail() {
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexAccessorTest.verifyFailOnSingleDropFailure(accessor, this.fusionIndexAccessor);
        }
    }

    private static void verifyFailOnSingleDropFailure(IndexAccessor failingAccessor, FusionIndexAccessor fusionIndexAccessor) {
        UncheckedIOException expectedFailure = new UncheckedIOException(new IOException("fail"));
        ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{expectedFailure}).when((Object)failingAccessor)).drop();
        UncheckedIOException e = (UncheckedIOException)org.junit.jupiter.api.Assertions.assertThrows(UncheckedIOException.class, () -> ((FusionIndexAccessor)fusionIndexAccessor).drop());
        org.junit.jupiter.api.Assertions.assertSame((Object)expectedFailure, (Object)e);
        ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)failingAccessor)).drop();
    }

    @Test
    void dropMustThrowIfAllFail() {
        ArrayList<UncheckedIOException> exceptions = new ArrayList<UncheckedIOException>();
        for (IndexAccessor indexAccessor : this.aliveAccessors) {
            UncheckedIOException exception = new UncheckedIOException(new IOException(indexAccessor.getClass().getSimpleName() + " fail"));
            exceptions.add(exception);
            ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)indexAccessor)).drop();
        }
        UncheckedIOException e = (UncheckedIOException)org.junit.jupiter.api.Assertions.assertThrows(UncheckedIOException.class, () -> this.fusionIndexAccessor.drop());
        Assertions.assertThat(exceptions).contains((Object[])new UncheckedIOException[]{e});
    }

    @Test
    void closeMustCloseAll() {
        this.fusionIndexAccessor.close();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor)).close();
        }
    }

    @Test
    void closeMustThrowIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            IndexAccessor accessor = this.aliveAccessors[i];
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor);
            this.initiateMocks();
        }
    }

    @Test
    void closeMustCloseOthersIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            IndexAccessor accessor = this.aliveAccessors[i];
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])ArrayUtil.without((Object[])this.aliveAccessors, (Object[])new IndexAccessor[]{accessor}));
            this.initiateMocks();
        }
    }

    @Test
    void closeMustThrowIfAllFail() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfAllThrow((AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])this.aliveAccessors);
    }

    @Test
    void allEntriesReaderMustCombineResultFromAll() {
        List[] ids = new List[this.aliveAccessors.length];
        long lastId = 0L;
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Arrays.asList(lastId++, lastId++);
        }
        this.mockAllEntriesReaders(ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL));
        for (List part : ids) {
            FusionIndexAccessorTest.assertResultContainsAll(result, part);
        }
    }

    @Test
    void allEntriesReaderMustCombineResultFromAllEmpty() {
        Object[] ids = new List[this.aliveAccessors.length];
        Arrays.fill(ids, Collections.emptyList());
        this.mockAllEntriesReaders((List<Long>[])ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    void allEntriesReaderMustCombineResultFromAllAccessors() {
        Object[] parts = new List[this.aliveAccessors.length];
        Arrays.fill(parts, new ArrayList());
        for (long i = 0L; i < 10L; ++i) {
            ((List)this.random.among(parts)).add(i);
        }
        this.mockAllEntriesReaders((List<Long>[])parts);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL));
        for (Object part : parts) {
            FusionIndexAccessorTest.assertResultContainsAll(result, (List<Long>)part);
        }
    }

    @Test
    void allEntriesReaderMustCloseAll() throws Exception {
        BoundedIterable[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
        this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL).close();
        for (BoundedIterable allEntriesReader : allEntriesReaders) {
            ((BoundedIterable)Mockito.verify((Object)allEntriesReader)).close();
        }
    }

    @Test
    void allEntriesReaderMustCloseOthersIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            Object[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL);
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)allEntriesReaders[i], (AutoCloseable)fusionAllEntriesReader, (AutoCloseable[])ArrayUtil.without((Object[])allEntriesReaders, (Object[])new BoundedIterable[]{allEntriesReaders[i]}));
            this.resetMocks();
        }
    }

    @Test
    void allEntriesReaderMustThrowIfOneThrow() throws Exception {
        for (IndexAccessor failingAccessor : this.aliveAccessors) {
            BoundedIterable<Long> failingReader = null;
            for (IndexAccessor aliveAccessor : this.aliveAccessors) {
                BoundedIterable<Long> reader = FusionIndexAccessorTest.mockSingleAllEntriesReader(aliveAccessor, Collections.emptyList());
                if (aliveAccessor != failingAccessor) continue;
                failingReader = reader;
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL);
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow(failingReader, (AutoCloseable)fusionAllEntriesReader);
        }
    }

    @Test
    void allEntriesReaderMustReportUnknownMaxCountIfAnyReportUnknownMaxCount() {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (j == i) {
                    FusionIndexAccessorTest.mockSingleAllEntriesReaderWithUnknownMaxCount(this.aliveAccessors[j], Collections.emptyList());
                    continue;
                }
                FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[j], Collections.emptyList());
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL);
            Assertions.assertThat((long)fusionAllEntriesReader.maxCount()).isEqualTo(-1L);
        }
    }

    @Test
    void allEntriesReaderMustReportFusionMaxCountOfAll() {
        long lastId = 0L;
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(lastId++, lastId++));
        }
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader(PageCursorTracer.NULL);
        Assertions.assertThat((long)fusionAllEntriesReader.maxCount()).isEqualTo(lastId);
    }

    @Test
    void shouldFailValueValidationIfAnyPartFail() {
        IllegalArgumentException failure = new IllegalArgumentException("failing");
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (i == j) {
                    ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)this.aliveAccessors[i])).validateBeforeCommit(ArgumentMatchers.anyLong(), (Value[])ArgumentMatchers.any(Value[].class));
                    continue;
                }
                ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)this.aliveAccessors[i])).validateBeforeCommit(ArgumentMatchers.anyLong(), (Value[])ArgumentMatchers.any(Value[].class));
            }
            try {
                this.fusionIndexAccessor.validateBeforeCommit(42L, new Value[]{Values.stringValue((String)"something")});
                continue;
            }
            catch (IllegalArgumentException e) {
                org.junit.jupiter.api.Assertions.assertSame((Object)failure, (Object)e);
            }
        }
    }

    @Test
    void shouldSucceedValueValidationIfAllSucceed() {
        this.fusionIndexAccessor.validateBeforeCommit(42L, new Value[]{Values.stringValue((String)"test value")});
    }

    @Test
    void shouldInstantiateReadersLazily() {
        IndexReader fusionReader = this.fusionIndexAccessor.newReader();
        for (IndexAccessor aliveAccessor : this.aliveAccessors) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{aliveAccessor});
        }
    }

    @Test
    void shouldInstantiateUpdatersLazily() {
        IndexUpdater updater = this.fusionIndexAccessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);
        for (IndexAccessor aliveAccessor : this.aliveAccessors) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{aliveAccessor});
        }
    }

    @Test
    void estimateNumberOfEntriesShouldSumCountFromAllParts() {
        long expected = 0L;
        long nextCount = 9L;
        for (IndexAccessor accessor : this.aliveAccessors) {
            Mockito.when((Object)accessor.estimateNumberOfEntries(PageCursorTracer.NULL)).thenReturn((Object)nextCount);
            expected += nextCount;
            nextCount *= 31L;
        }
        long numberOfEntries = this.fusionIndexAccessor.estimateNumberOfEntries(PageCursorTracer.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)numberOfEntries);
        for (IndexAccessor aliveAccessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)aliveAccessor)).estimateNumberOfEntries(PageCursorTracer.NULL);
        }
    }

    @Test
    void estimateNumberOfEntriesShouldReturnUnknownIfAnyPartIsUnknown() {
        long nextCount = 9L;
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            IndexAccessor accessor = this.aliveAccessors[i];
            Mockito.when((Object)accessor.estimateNumberOfEntries(PageCursorTracer.NULL)).thenReturn((Object)(i == 0 ? -1L : nextCount));
            nextCount *= 31L;
        }
        long numberOfEntries = this.fusionIndexAccessor.estimateNumberOfEntries(PageCursorTracer.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)numberOfEntries);
        for (IndexAccessor aliveAccessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)aliveAccessor)).estimateNumberOfEntries(PageCursorTracer.NULL);
        }
    }

    private static void assertResultContainsAll(Set<Long> result, List<Long> expectedEntries) {
        for (long expectedEntry : expectedEntries) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.contains(expectedEntry), (String)("Expected to contain " + expectedEntry + ", but was " + result));
        }
    }

    private static BoundedIterable<Long> mockSingleAllEntriesReader(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReader(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    private static BoundedIterable<Long> mockedAllEntriesReader(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(true, entries);
    }

    private static void mockSingleAllEntriesReaderWithUnknownMaxCount(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReaderUnknownMaxCount(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn(allEntriesReader);
    }

    private static BoundedIterable<Long> mockedAllEntriesReaderUnknownMaxCount(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(false, entries);
    }

    private static BoundedIterable<Long> mockedAllEntriesReader(boolean knownMaxCount, List<Long> entries) {
        BoundedIterable mockedAllEntriesReader = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)mockedAllEntriesReader.maxCount()).thenReturn((Object)(knownMaxCount ? (long)entries.size() : -1L));
        Mockito.when((Object)mockedAllEntriesReader.iterator()).thenReturn(entries.iterator());
        return mockedAllEntriesReader;
    }

    private void mockAllEntriesReaders(List<Long> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[i], entries[i]);
        }
    }
}

