/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.neo4j.kernel.impl.locking.LockWorkerState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.test.OtherThreadExecutor;

public class LockWorker
extends OtherThreadExecutor {
    private final LockWorkerState state;

    public LockWorker(String name, Locks locks) {
        super(name);
        this.state = new LockWorkerState(locks);
    }

    private Future<Void> perform(Callable<Void> acquireLockCommand, boolean wait) throws Exception {
        Future future = this.executeDontWait(acquireLockCommand);
        if (wait) {
            this.awaitFuture(future);
        } else {
            this.waitUntilWaiting();
        }
        return future;
    }

    public Future<Void> getReadLock(long resource, boolean wait) throws Exception {
        return this.perform(() -> {
            this.state.doing("+R " + resource + ", wait:" + wait);
            this.state.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{resource});
            this.state.done();
            return null;
        }, wait);
    }

    public Future<Void> getWriteLock(long resource, boolean wait) throws Exception {
        return this.perform(() -> {
            this.state.doing("+W " + resource + ", wait:" + wait);
            this.state.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{resource});
            this.state.done();
            return null;
        }, wait);
    }

    public void releaseReadLock(long resource) throws Exception {
        this.perform(() -> {
            this.state.doing("-R " + resource);
            this.state.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{resource});
            this.state.done();
            return null;
        }, true);
    }

    public void releaseWriteLock(long resource) throws Exception {
        this.perform(() -> {
            this.state.doing("-W " + resource);
            this.state.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{resource});
            this.state.done();
            return null;
        }, true);
    }
}

