/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.nio.file.Path;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockWorkFailureDump;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class RWLockCompatibility
extends LockCompatibilityTestSupport {
    RWLockCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void testSingleThread() {
        int i;
        Assertions.assertThrows(Exception.class, () -> this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L}), (String)"Invalid release should throw exception");
        Assertions.assertThrows(Exception.class, () -> this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L}), (String)"Invalid release should throw exception");
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertThrows(Exception.class, () -> this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L}), (String)"Invalid release should throw exception");
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertThrows(Exception.class, () -> this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L}), (String)"Invalid release should throw exception");
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
                continue;
            }
            this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
        for (i = 9; i >= 0; --i) {
            if (i % 2 == 0) {
                this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
                continue;
            }
            this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
    }

    @Test
    void testMultipleThreads() throws Exception {
        LockWorker t1 = new LockWorker("T1", this.locks);
        LockWorker t2 = new LockWorker("T2", this.locks);
        LockWorker t3 = new LockWorker("T3", this.locks);
        LockWorker t4 = new LockWorker("T4", this.locks);
        long r1 = 1L;
        try {
            t1.getReadLock(r1, true);
            t2.getReadLock(r1, true);
            t3.getReadLock(r1, true);
            Future<Void> t4Wait = t4.getWriteLock(r1, false);
            t3.releaseReadLock(r1);
            t2.releaseReadLock(r1);
            Assertions.assertFalse((boolean)t4Wait.isDone());
            t1.releaseReadLock(r1);
            t4.awaitFuture(t4Wait);
            t4.getReadLock(r1, true);
            t4.getReadLock(r1, true);
            Future<Void> t1Wait = t1.getReadLock(r1, false);
            t4.getReadLock(r1, true);
            t4.releaseReadLock(r1);
            t4.getWriteLock(r1, true);
            t4.releaseWriteLock(r1);
            Assertions.assertFalse((boolean)t1Wait.isDone());
            t4.releaseWriteLock(r1);
            t1.awaitFuture(t1Wait);
            t4.releaseReadLock(r1);
            t4Wait = t4.getWriteLock(r1, false);
            t1.releaseReadLock(r1);
            t4.awaitFuture(t4Wait);
            t4.releaseReadLock(r1);
            t4.releaseWriteLock(r1);
            t4.getWriteLock(r1, true);
            t1Wait = t1.getReadLock(r1, false);
            Future<Void> t2Wait = t2.getReadLock(r1, false);
            Future<Void> t3Wait = t3.getReadLock(r1, false);
            t4.getReadLock(r1, true);
            t4.releaseWriteLock(r1);
            t1.awaitFuture(t1Wait);
            t2.awaitFuture(t2Wait);
            t3.awaitFuture(t3Wait);
            t1Wait = t1.getWriteLock(r1, false);
            t2.releaseReadLock(r1);
            t4.releaseReadLock(r1);
            t3.releaseReadLock(r1);
            t1.awaitFuture(t1Wait);
            t1.releaseWriteLock(r1);
            t2.getReadLock(r1, true);
            t1.releaseReadLock(r1);
            t2.getWriteLock(r1, true);
            t2.releaseWriteLock(r1);
            t2.releaseReadLock(r1);
        }
        catch (Exception e) {
            LockWorkFailureDump dumper = new LockWorkFailureDump(this.testDir.file(this.getClass().getSimpleName()));
            Path file = dumper.dumpState(this.locks, t1, t2, t3, t4);
            throw new RuntimeException("Failed, forensics information dumped to " + file.toAbsolutePath(), e);
        }
        finally {
            t1.close();
            t2.close();
            t3.close();
            t4.close();
        }
    }

    @Test
    void testStressMultipleThreads() throws Exception {
        boolean anyAlive;
        int i;
        long r1 = 1L;
        int numThreads = 25;
        StressThread[] stressThreads = new StressThread[numThreads];
        CountDownLatch startSignal = new CountDownLatch(1);
        for (i = 0; i < numThreads; ++i) {
            stressThreads[i] = new StressThread("Thread" + i, 75, 9, 0.5f, r1, startSignal);
        }
        for (i = 0; i < numThreads; ++i) {
            stressThreads[i].start();
        }
        startSignal.countDown();
        long end = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
        while ((anyAlive = this.anyAliveAndAllWell(stressThreads)) && System.currentTimeMillis() < end) {
            this.sleepALittle();
        }
        for (StressThread stressThread : stressThreads) {
            if (stressThread.error != null) {
                throw stressThread.error;
            }
            if (!stressThread.isAlive()) continue;
            for (StackTraceElement stackTraceElement : stressThread.getStackTrace()) {
                System.out.println(stackTraceElement);
            }
        }
        if (anyAlive) {
            throw new RuntimeException("Expected all threads to complete.");
        }
    }

    private void sleepALittle() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean anyAliveAndAllWell(StressThread[] stressThreads) {
        for (StressThread stressThread : stressThreads) {
            if (stressThread.error != null) {
                return false;
            }
            if (!stressThread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public class StressThread
    extends Thread {
        private final Random rand = new Random(System.currentTimeMillis());
        private final Object READ = new Object();
        private final Object WRITE = new Object();
        private final String name;
        private final int numberOfIterations;
        private final int depthCount;
        private final float readWriteRatio;
        private final CountDownLatch startSignal;
        private final Locks.Client client;
        private final long nodeId;
        private Exception error;

        StressThread(String name, int numberOfIterations, int depthCount, float readWriteRatio, long nodeId, CountDownLatch startSignal) {
            this.nodeId = nodeId;
            this.client = RWLockCompatibility.this.locks.newClient();
            this.name = name;
            this.numberOfIterations = numberOfIterations;
            this.depthCount = depthCount;
            this.readWriteRatio = readWriteRatio;
            this.startSignal = startSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startSignal.await();
                Stack<Object> lockStack = new Stack<Object>();
                for (int i = 0; i < this.numberOfIterations; ++i) {
                    try {
                        int depth = this.depthCount;
                        do {
                            float f;
                            if ((f = this.rand.nextFloat()) < this.readWriteRatio) {
                                this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                                lockStack.push(this.READ);
                                continue;
                            }
                            this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                            lockStack.push(this.WRITE);
                        } while (--depth > 0);
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == this.READ) {
                                this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                                continue;
                            }
                            this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                        }
                    }
                    catch (DeadlockDetectedException deadlockDetectedException) {
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == this.READ) {
                                this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                                continue;
                            }
                            this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == this.READ) {
                                this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                                continue;
                            }
                            this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                        }
                        throw throwable;
                    }
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == this.READ) {
                            this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                            continue;
                        }
                        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{this.nodeId});
                    }
                    continue;
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

