/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

class DefaultRelationshipTraversalCursorTest {
    private static final long node = 42L;
    private static final int type = 9999;
    private static final int type2 = 9998;
    private static final long relationship = 100L;
    private final DefaultPooledCursors pool = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
    private static final Rel NO_REL = DefaultRelationshipTraversalCursorTest.rel(-1L, -1L, -1L, -1);

    DefaultRelationshipTraversalCursorTest() {
    }

    @Test
    void regularTraversal() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.emptyTxState();
        cursor.init(42L, 100L, RelationshipSelection.ALL_RELATIONSHIPS, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 100L, 102L, 104L);
    }

    @Test
    void regularTraversalWithTxState() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(3L, 4L);
        cursor.init(42L, 100L, RelationshipSelection.ALL_RELATIONSHIPS, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 4L, 100L, 102L, 104L);
    }

    @Test
    void traversalWithTxStateFiltering() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(DefaultRelationshipTraversalCursorTest.rel(100L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(102L, 42L, 51L, 9999), DefaultRelationshipTraversalCursorTest.rel(104L, 42L, 52L, 9999));
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 42L, 50L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 42L, 52L, 9999));
        cursor.init(42L, 100L, RelationshipSelection.selection((int)9999, (Direction)Direction.OUTGOING), read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 7L, 6L, 100L, 102L, 104L);
    }

    @Test
    void emptyStoreOutgoingOfType() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 42L, 50L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 42L, 52L, 9999));
        cursor.init(42L, 100L, RelationshipSelection.selection((int)9999, (Direction)Direction.OUTGOING), read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 7L, 6L);
    }

    @Test
    void emptyStoreIncomingOfType() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 50L, 42L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 56L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(8L, 42L, 52L, 9999));
        cursor.init(42L, 100L, RelationshipSelection.selection((int)9999, (Direction)Direction.INCOMING), read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 4L, 7L, 6L);
    }

    @Test
    void emptyStoreAllOfType() {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(2L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 50L, 42L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 56L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(8L, 42L, 52L, 9999));
        cursor.init(42L, 100L, RelationshipSelection.selection((int)9999, (Direction)Direction.BOTH), read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 8L, 7L, 2L, 6L);
    }

    private static Read emptyTxState() {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        TestRead read = new TestRead(ktx);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        return read;
    }

    private static Read txState(long ... ids) {
        return DefaultRelationshipTraversalCursorTest.txState((Rel[])LongStream.of(ids).mapToObj(id -> DefaultRelationshipTraversalCursorTest.rel(id, 42L, 42L, 9999)).toArray(Rel[]::new));
    }

    private static Read txState(Rel ... rels) {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        TestRead read = new TestRead(ktx);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        if (rels.length > 0) {
            TxState txState = new TxState();
            for (Rel rel : rels) {
                txState.relationshipDoCreate(rel.relId, rel.type, rel.sourceId, rel.targetId);
            }
            Mockito.when((Object)read.hasTxStateWithChanges()).thenReturn((Object)true);
            Mockito.when((Object)read.txState()).thenReturn((Object)txState);
        }
        return read;
    }

    private static void assertRelationships(DefaultRelationshipTraversalCursor cursor, long ... expected) {
        for (long expectedId : expected) {
            Assertions.assertTrue((boolean)cursor.next(), (String)("Expected relationship " + expectedId + " but got none"));
            Assertions.assertEquals((long)expectedId, (long)cursor.relationshipReference(), (String)("Expected relationship " + expectedId + " got " + cursor.relationshipReference()));
        }
        Assertions.assertFalse((boolean)cursor.next(), (String)("Expected no more relationships, but got " + cursor.relationshipReference()));
    }

    private static Rel rel(long relId, long startId, long endId, int type) {
        return new Rel(relId, startId, endId, type);
    }

    private static StorageRelationshipTraversalCursor emptyStoreCursor() {
        return DefaultRelationshipTraversalCursorTest.storeCursor(new Rel[0]);
    }

    private static StorageRelationshipTraversalCursor storeCursor(long ... ids) {
        return DefaultRelationshipTraversalCursorTest.storeCursor((Rel[])LongStream.of(ids).mapToObj(id -> DefaultRelationshipTraversalCursorTest.rel(id, -1L, -1L, -1)).toArray(Rel[]::new));
    }

    private static StorageRelationshipTraversalCursor storeCursor(final Rel ... rels) {
        return new StorageRelationshipTraversalCursor(){
            private long nodeReference;
            private RelationshipSelection selection;
            private int i = -1;
            private Rel rel = NO_REL;

            public long neighbourNodeReference() {
                return this.rel.sourceId == 42L ? this.rel.targetId : this.rel.sourceId;
            }

            public long originNodeReference() {
                return 42L;
            }

            public void init(long nodeReference, long reference, RelationshipSelection selection) {
                this.nodeReference = nodeReference;
                this.selection = selection;
            }

            public int type() {
                return this.rel.type;
            }

            public long sourceNodeReference() {
                return this.rel.sourceId;
            }

            public long targetNodeReference() {
                return this.rel.targetId;
            }

            public boolean hasProperties() {
                throw new UnsupportedOperationException("not implemented");
            }

            public long propertiesReference() {
                throw new UnsupportedOperationException("not implemented");
            }

            public void properties(StoragePropertyCursor propertyCursor) {
                throw new UnsupportedOperationException("not implemented");
            }

            public long entityReference() {
                return this.rel.relId;
            }

            public boolean next() {
                while (this.i + 1 < rels.length) {
                    ++this.i;
                    if (this.i < 0 || this.i >= rels.length) {
                        this.rel = NO_REL;
                        return false;
                    }
                    this.rel = rels[this.i];
                    if (!this.selection.test(this.rel.type, this.rel.direction(this.nodeReference))) continue;
                    return true;
                }
                return false;
            }

            public void reset() {
            }

            public void setForceLoad() {
            }

            public void close() {
            }
        };
    }

    private static class TestRead
    extends Read {
        TestRead(KernelTransactionImplementation ktx) {
            super((StorageReader)Mockito.mock(StorageReader.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), PageCursorTracer.NULL, ktx, Config.defaults());
        }

        public IndexReader indexReader(IndexDescriptor index, boolean fresh) {
            return null;
        }

        TokenScanReader labelScanReader() {
            return null;
        }

        TokenScanReader relationshipTypeScanReader() {
            return null;
        }

        public UserFunctionHandle functionGet(QualifiedName name) {
            return null;
        }

        public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
            return null;
        }

        public ProcedureHandle procedureGet(QualifiedName name) {
            return null;
        }

        public Set<ProcedureSignature> proceduresGetAll() {
            return null;
        }

        public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) {
            return null;
        }

        public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) {
            return null;
        }

        public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) {
            return null;
        }

        public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] arguments, ProcedureCallContext context) {
            return null;
        }

        public AnyValue functionCall(int id, AnyValue[] arguments) {
            return null;
        }

        public UserAggregator aggregationFunction(int id) {
            return null;
        }

        public PageCursorTracer cursorTracer() {
            return null;
        }

        public MemoryTracker memoryTracker() {
            return null;
        }

        public IndexReadSession indexReadSession(IndexDescriptor index) {
            return null;
        }

        public void prepareForLabelScans() {
        }

        public boolean nodeExists(long reference) {
            return false;
        }

        public long countsForNode(int labelId) {
            return 0L;
        }

        public long countsForNodeWithoutTxState(int labelId) {
            return 0L;
        }

        public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
            return 0L;
        }

        public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
            return 0L;
        }

        public long nodesGetCount() {
            return 0L;
        }

        public long relationshipsGetCount() {
            return 0L;
        }

        public boolean relationshipExists(long reference) {
            return false;
        }

        public boolean nodeDeletedInTransaction(long node) {
            return false;
        }

        public boolean relationshipDeletedInTransaction(long relationship) {
            return false;
        }

        public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
            return null;
        }

        public Value relationshipPropertyChangeInTransactionOrNull(long relationship, int propertyKeyId) {
            return null;
        }

        public boolean transactionStateHasChanges() {
            return false;
        }

        public Iterator<IndexDescriptor> indexForSchemaNonTransactional(SchemaDescriptor schema) {
            return null;
        }

        public double indexUniqueValuesSelectivity(IndexDescriptor index) {
            return 0.0;
        }

        public long indexSize(IndexDescriptor index) {
            return 0L;
        }

        public long nodesCountIndexed(IndexDescriptor index, long nodeId, int propertyKeyId, Value value) {
            return 0L;
        }

        public IndexSample indexSample(IndexDescriptor index) {
            return null;
        }

        public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
            return null;
        }

        public boolean constraintExists(ConstraintDescriptor descriptor) {
            return false;
        }

        public SchemaReadCore snapshot() {
            return null;
        }

        public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
            return null;
        }

        public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
            return null;
        }

        public void schemaStateFlush() {
        }

        public IndexDescriptor indexGetForName(String name) {
            return null;
        }

        public ConstraintDescriptor constraintGetForName(String name) {
            return null;
        }

        public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
            return null;
        }

        public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
            return null;
        }

        public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
            return null;
        }

        public Iterator<IndexDescriptor> indexesGetAll() {
            return null;
        }

        public InternalIndexState indexGetState(IndexDescriptor index) {
            return null;
        }

        public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) {
            return null;
        }

        public String indexGetFailure(IndexDescriptor index) {
            return null;
        }

        public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
            return null;
        }

        public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
            return null;
        }

        public Iterator<ConstraintDescriptor> constraintsGetAll() {
            return null;
        }
    }

    private static class Rel {
        final long relId;
        final long sourceId;
        final long targetId;
        final int type;

        Rel(long relId, long sourceId, long targetId, int type) {
            this.relId = relId;
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.type = type;
        }

        RelationshipDirection direction(long nodeReference) {
            if (this.sourceId == this.targetId) {
                return RelationshipDirection.LOOP;
            }
            return nodeReference == this.sourceId ? RelationshipDirection.OUTGOING : RelationshipDirection.INCOMING;
        }
    }
}

