/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.function.LongPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.StubCursorFactory;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubRead;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.newapi.DetachingRelationshipDeleter;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

class DetachingRelationshipDeleterTest {
    private static final long nodeId = 42L;
    private static final int TYPE = 77;
    private final KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);

    DetachingRelationshipDeleterTest() {
    }

    @Test
    void shouldLockNodesInOrderAndConsumeTheRelationships() {
        Collector collector = new Collector();
        DetachingRelationshipDeleter locking = new DetachingRelationshipDeleter((LongPredicate)collector);
        DetachingRelationshipDeleterTest.returnRelationships(this.ktx, new TestRelationshipChain(42L).outgoing(21L, 43L, 0).incoming(22L, 40L, 77).outgoing(23L, 41L, 77).outgoing(2L, 3L, 77).incoming(3L, 49L, 77).outgoing(50L, 41L, 77));
        Mockito.when((Object)this.ktx.statementLocks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockNodesAndDeleteRelationships(42L, this.ktx);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 40L, 41L, 42L, 43L, 49L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{2L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{3L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{22L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{23L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{50L});
        Assertions.assertEquals((Object)Iterators.set((Object[])new Long[]{21L, 22L, 23L, 2L, 3L, 50L}), collector.set);
    }

    @Test
    void lockNodeWithoutRelationships() {
        Collector collector = new Collector();
        DetachingRelationshipDeleter locking = new DetachingRelationshipDeleter((LongPredicate)collector);
        DetachingRelationshipDeleterTest.returnRelationships(this.ktx, new TestRelationshipChain(42L));
        Mockito.when((Object)this.ktx.statementLocks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        locking.lockNodesAndDeleteRelationships(42L, this.ktx);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    public static void returnRelationships(KernelTransactionImplementation ktx, TestRelationshipChain relIds) {
        StubRead read = new StubRead();
        Mockito.when((Object)ktx.dataRead()).thenReturn((Object)read);
        StubCursorFactory cursorFactory = new StubCursorFactory(true);
        cursorFactory.withRelationshipTraversalCursors(new RelationshipTraversalCursor[]{new StubRelationshipCursor(relIds)});
        Mockito.when((Object)ktx.lockTracer()).thenReturn((Object)LockTracer.NONE);
        Mockito.when((Object)ktx.cursors()).thenReturn((Object)cursorFactory);
        Mockito.when((Object)ktx.ambientNodeCursor()).thenAnswer(args -> new StubNodeCursor(false).withNode(42L));
    }

    private static class Collector
    implements LongPredicate {
        public final Set<Long> set = new HashSet<Long>();

        private Collector() {
        }

        @Override
        public boolean test(long input) {
            this.set.add(input);
            return true;
        }
    }
}

