/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class SchemaIndexMigratorTest {
    @Inject
    private TestDirectory testDirectory;
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final ProgressReporter progressReporter = (ProgressReporter)Mockito.mock(ProgressReporter.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private DatabaseLayout databaseLayout;
    private DatabaseLayout migrationLayout;

    SchemaIndexMigratorTest() {
    }

    @BeforeEach
    void setup() {
        this.databaseLayout = Neo4jLayout.of((Path)this.testDirectory.directory("store")).databaseLayout("neo4j");
        this.migrationLayout = Neo4jLayout.of((Path)this.testDirectory.directory("migrationDir")).databaseLayout("neo4j");
    }

    @Test
    void schemaAndLabelIndexesRemovedAfterSuccessfulMigration() throws IOException {
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        StoreVersion version = (StoreVersion)Mockito.mock(StoreVersion.class);
        Mockito.when((Object)version.hasCompatibleCapabilities((StoreVersion)ArgumentMatchers.any(), (CapabilityType)ArgumentMatchers.eq((Object)CapabilityType.INDEX))).thenReturn((Object)false);
        Mockito.when((Object)storageEngineFactory.versionInformation(ArgumentMatchers.anyString())).thenReturn((Object)version);
        IndexDirectoryStructure directoryStructure = (IndexDirectoryStructure)Mockito.mock(IndexDirectoryStructure.class);
        Path indexProviderRootDirectory = this.databaseLayout.file("just-some-directory");
        Mockito.when((Object)directoryStructure.rootDirectory()).thenReturn((Object)indexProviderRootDirectory);
        SchemaIndexMigrator migrator = new SchemaIndexMigrator("Test migrator", this.fs, directoryStructure, storageEngineFactory);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor("key", "version"));
        migrator.migrate(this.databaseLayout, this.migrationLayout, this.progressReporter, "from", "to");
        migrator.moveMigratedFiles(this.migrationLayout, this.databaseLayout, "from", "to");
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(indexProviderRootDirectory);
    }
}

