/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;

class ThresholdConfigValueTest {
    ThresholdConfigValueTest() {
    }

    @Test
    void shouldParseCorrectly() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"25 files");
        Assertions.assertEquals((Object)"files", (Object)value.type);
        Assertions.assertEquals((long)25L, (long)value.value);
        value = ThresholdConfigParser.parse((String)"4g size");
        Assertions.assertEquals((Object)"size", (Object)value.type);
        Assertions.assertEquals((long)0x100000000L, (long)value.value);
    }

    @Test
    void shouldThrowExceptionOnUnknownType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ThresholdConfigParser.parse((String)"more than one spaces is invalid"));
    }

    @Test
    void shouldReturnNoPruningForTrue() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"true");
        Assertions.assertSame((Object)ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING, (Object)value);
    }

    @Test
    void shouldReturnKeepOneEntryForFalse() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"false");
        Assertions.assertEquals((Object)"entries", (Object)value.type);
        Assertions.assertEquals((long)1L, (long)value.value);
    }
}

