/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedMultiFileTransactionCursor;
import org.neo4j.storageengine.api.StoreId;

class ReversedMultiFileTransactionCursorTest {
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);

    ReversedMultiFileTransactionCursorTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        Mockito.when((Object)this.logFile.extractHeader(ArgumentMatchers.anyLong())).thenAnswer(invocation -> new LogHeader(((Long)invocation.getArgument(0)).longValue(), 1L, StoreId.UNKNOWN));
    }

    @Test
    void shouldReadSingleVersionReversed() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.logFile, this.log(5), 0L, this.start());
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 5L, 0L);
    }

    @Test
    void shouldReadMultipleVersionsReversed() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.logFile, this.log(5, 3, 8), 2L, this.start());
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 16L, 0L);
    }

    @Test
    void shouldRespectStartLogPosition() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.logFile, this.log(5, 6, 8), 2L, new LogPosition(1L, 67L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 19L, 8L);
    }

    @Test
    void shouldHandleEmptyLogsMidStream() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.logFile, this.log(5, 0, 2, 0, 3), 4L, this.start());
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 10L, 0L);
    }

    @Test
    void shouldHandleEmptySingleLogVersion() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.logFile, this.log(0), 0L, this.start());
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 0L, 0L);
    }

    private void assertTransactionRange(CommittedTransactionRepresentation[] reversed, long highTxId, long lowTxId) {
        long expectedTxId = highTxId;
        for (CommittedTransactionRepresentation transaction : reversed) {
            Assertions.assertEquals((long)(--expectedTxId), (long)transaction.getCommitEntry().getTxId());
        }
        Assertions.assertEquals((long)lowTxId, (long)expectedTxId);
    }

    private ThrowingFunction<LogPosition, TransactionCursor, IOException> log(int ... transactionCounts) throws IOException {
        long baseOffset = this.start().getByteOffset();
        ThrowingFunction result = (ThrowingFunction)Mockito.mock(ThrowingFunction.class);
        AtomicLong txId = new AtomicLong(0L);
        CommittedTransactionRepresentation[][] logs = new CommittedTransactionRepresentation[transactionCounts.length][];
        for (int logVersion = 0; logVersion < transactionCounts.length; ++logVersion) {
            logs[logVersion] = this.transactions(transactionCounts[logVersion], txId);
        }
        Mockito.when((Object)((TransactionCursor)result.apply((Object)((LogPosition)ArgumentMatchers.any(LogPosition.class))))).thenAnswer(invocation -> {
            LogPosition position = (LogPosition)invocation.getArgument(0);
            if (position == null) {
                return null;
            }
            CommittedTransactionRepresentation[] transactions = logs[Math.toIntExact(position.getLogVersion())];
            Object[] subset = Arrays.copyOfRange(transactions, Math.toIntExact(position.getByteOffset() - baseOffset), transactions.length);
            ArrayUtil.reverse((Object[])subset);
            return GivenTransactionCursor.given((CommittedTransactionRepresentation[])subset);
        });
        return result;
    }

    private LogPosition start() {
        return new LogPosition(0L, 64L);
    }

    private CommittedTransactionRepresentation[] transactions(int count, AtomicLong txId) {
        CommittedTransactionRepresentation[] result = new CommittedTransactionRepresentation[count];
        for (int i = 0; i < count; ++i) {
            CommittedTransactionRepresentation transaction = result[i] = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
            LogEntryCommit commitEntry = (LogEntryCommit)Mockito.mock(LogEntryCommit.class);
            Mockito.when((Object)commitEntry.getTxId()).thenReturn((Object)txId.getAndIncrement());
            Mockito.when((Object)transaction.getCommitEntry()).thenReturn((Object)commitEntry);
        }
        return result;
    }
}

