/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;

public class GenericNativeIndexProviderFactory
extends AbstractIndexProviderFactory {
    public GenericNativeIndexProviderFactory() {
        super(GenericNativeIndexProvider.KEY);
    }

    @Override
    protected Class<?> loggingClass() {
        return GenericNativeIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return GenericNativeIndexProvider.DESCRIPTOR;
    }

    @Override
    protected GenericNativeIndexProvider internalCreate(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        return GenericNativeIndexProviderFactory.create(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static GenericNativeIndexProvider create(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode mode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)storeDir);
        boolean readOnly = (Boolean)config.get(GraphDatabaseSettings.read_only) != false && OperationalMode.SINGLE == mode;
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder(pageCache, fs).withMonitor(monitor).withReadOnly(readOnly).build();
        return new GenericNativeIndexProvider(databaseIndexContext, directoryStructure, recoveryCleanupWorkCollector, config);
    }
}

