/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.storable.Value;

public class NativeHitIterator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator
implements PrimitiveLongResourceIterator {
    private final Seeker<KEY, VALUE> seeker;
    private final Collection<Seeker<KEY, VALUE>> toRemoveFromWhenExhausted;
    private boolean closed;

    NativeHitIterator(Seeker<KEY, VALUE> seeker, Collection<Seeker<KEY, VALUE>> toRemoveFromWhenExhausted) {
        this.seeker = seeker;
        this.toRemoveFromWhenExhausted = toRemoveFromWhenExhausted;
    }

    protected boolean fetchNext() {
        try {
            while (this.seeker.next()) {
                NativeIndexKey key = (NativeIndexKey)((Object)this.seeker.key());
                if (!this.acceptValues(key.asValues())) continue;
                return this.next(key.getEntityId());
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    boolean acceptValues(Value[] value) {
        return true;
    }

    private void ensureCursorClosed() throws IOException {
        if (!this.closed) {
            this.seeker.close();
            this.toRemoveFromWhenExhausted.remove(this.seeker);
            this.closed = true;
        }
    }

    public void close() {
        try {
            this.ensureCursorClosed();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

