/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.impl.util.WrappingEntity;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class RelationshipEntityWrappingValue
extends RelationshipValue
implements WrappingEntity<Relationship> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipEntityWrappingValue.class) + RelationshipEntity.SHALLOW_SIZE;
    private final Relationship relationship;
    private volatile TextValue type;
    private volatile MapValue properties;
    private volatile NodeValue startNode;
    private volatile NodeValue endNode;

    RelationshipEntityWrappingValue(Relationship relationship) {
        super(relationship.getId());
        this.relationship = relationship;
    }

    public Relationship relationshipEntity() {
        return this.relationship;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeRelationshipReference(this.id());
        } else {
            MapValue p;
            RelationshipEntity proxy;
            if (this.relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)this.relationship).initializeData()) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship));
            }
            try {
                p = this.properties();
            }
            catch (NotFoundException e) {
                p = VirtualValues.EMPTY_MAP;
            }
            catch (IllegalStateException e) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship), (Throwable)e);
            }
            if (this.id() < 0L) {
                writer.writeVirtualRelationshipHack((Object)this.relationship);
            }
            writer.writeRelationship(this.id(), this.startNode().id(), this.endNode().id(), this.type(), p);
        }
    }

    public long estimatedHeapUsage() {
        long size = SHALLOW_SIZE;
        if (this.type != null) {
            size += this.type.estimatedHeapUsage();
        }
        if (this.properties != null) {
            size += this.properties.estimatedHeapUsage();
        }
        if (this.startNode != null) {
            size += this.startNode.estimatedHeapUsage();
        }
        if (this.endNode != null) {
            size += this.endNode.estimatedHeapUsage();
        }
        return size;
    }

    public void populate(RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        try {
            RelationshipEntity proxy;
            if (this.relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)this.relationship).initializeData(relCursor)) {
                return;
            }
            this.type();
            this.properties(propertyCursor);
            this.startNode();
            this.endNode();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void populate() {
        try {
            RelationshipEntity proxy;
            if (this.relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)this.relationship).initializeData()) {
                return;
            }
            this.type();
            this.properties();
            this.startNode();
            this.endNode();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean isPopulated() {
        return this.type != null && this.properties != null && this.startNode != null && this.endNode != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue startNode() {
        NodeValue start = this.startNode;
        if (start == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                start = this.startNode;
                if (start == null) {
                    start = this.startNode = ValueUtils.fromNodeEntity(this.relationship.getStartNode());
                }
            }
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue endNode() {
        NodeValue end = this.endNode;
        if (end == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                end = this.endNode;
                if (end == null) {
                    end = this.endNode = ValueUtils.fromNodeEntity(this.relationship.getEndNode());
                }
            }
        }
        return end;
    }

    public NodeValue otherNode(VirtualNodeValue node) {
        if (node instanceof NodeEntityWrappingNodeValue) {
            Node proxy = ((NodeEntityWrappingNodeValue)node).getEntity();
            return ValueUtils.fromNodeEntity(this.relationship.getOtherNode(proxy));
        }
        return super.otherNode(node);
    }

    public long otherNodeId(long node) {
        return this.relationship.getOtherNodeId(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextValue type() {
        TextValue t = this.type;
        if (t == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                t = this.type;
                if (t == null) {
                    t = this.type = Values.utf8Value((String)this.relationship.getType().name());
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                m = this.properties;
                if (m == null) {
                    m = this.properties = ValueUtils.asMapValue(this.relationship.getAllProperties());
                }
            }
        }
        return m;
    }

    @Override
    public Relationship getEntity() {
        return this.relationship;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties(PropertyCursor propertyCursor) {
        MapValue m = this.properties;
        if (m == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                m = this.properties;
                if (m == null) {
                    Map<String, Object> relProperties = this.relationship instanceof RelationshipEntity ? ((RelationshipEntity)this.relationship).getAllProperties(propertyCursor) : this.relationship.getAllProperties();
                    m = this.properties = ValueUtils.asMapValue(relProperties);
                }
            }
        }
        return m;
    }
}

