/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CompositeCheckpointLogFile;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class TransactionLogFiles
extends LifecycleAdapter
implements LogFiles {
    public static final DirectoryStream.Filter<Path> DEFAULT_FILENAME_FILTER = TransactionLogFilesHelper.DEFAULT_FILENAME_FILTER;
    private final CheckpointFile checkpointLogFile;
    private final TransactionLogFile logFile;
    private final Path logsDirectory;
    private LifeSupport logFilesLife;

    TransactionLogFiles(Path logsDirectory, String name, TransactionLogFilesContext context) {
        this.logsDirectory = logsDirectory;
        this.logFile = new TransactionLogFile(this, context, name);
        this.checkpointLogFile = new CompositeCheckpointLogFile(this, context);
    }

    public void init() throws IOException {
        this.logFilesLife = new LifeSupport();
        this.logFilesLife.add((Lifecycle)this.logFile);
        this.logFilesLife.add((Lifecycle)this.checkpointLogFile);
        this.logFilesLife.init();
    }

    public void start() throws IOException {
        this.logFilesLife.start();
    }

    public void stop() throws IOException {
        this.logFilesLife.stop();
    }

    public void shutdown() {
        this.logFilesLife.shutdown();
    }

    @Override
    public Path[] logFiles() {
        return (Path[])ArrayUtil.concat((Object[])this.logFile.getMatchedFiles(), (Object[])this.checkpointLogFile.getDetachedCheckpointFiles());
    }

    @Override
    public boolean isLogFile(Path path) {
        try {
            return DEFAULT_FILENAME_FILTER.accept(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public LogTailInformation getTailInformation() {
        return this.checkpointLogFile.getTailInformation();
    }

    @Override
    public Path logFilesDirectory() {
        return this.logsDirectory;
    }

    @Override
    public LogFile getLogFile() {
        return this.logFile;
    }

    @Override
    public CheckpointFile getCheckpointFile() {
        return this.checkpointLogFile;
    }
}

