/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexEntryUpdateTest {
    private final Value[] multiValue = new Value[]{Values.of((Object)"value"), Values.of((Object)"value2")};
    private final Value singleValue = Values.of((Object)"value");

    IndexEntryUpdateTest() {
    }

    @Test
    void indexEntryUpdatesShouldBeEqual() {
        IndexEntryUpdate a = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate b = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Assertions.assertThat((Object)a).isEqualTo((Object)b);
        Assertions.assertThat((int)a.hashCode()).isEqualTo(b.hashCode());
    }

    @Test
    void addShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        Assertions.assertThat((Object)single).isNotEqualTo((Object)multi);
        Assertions.assertThat((Object[])single.values()).isEqualTo((Object)new Object[]{this.singleValue});
        Assertions.assertThat((Object[])multi.values()).isEqualTo((Object)this.multiValue);
    }

    @Test
    void removeShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        Assertions.assertThat((Object)single).isNotEqualTo((Object)multi);
        Assertions.assertThat((Object[])single.values()).isEqualTo((Object)new Object[]{this.singleValue});
        Assertions.assertThat((Object[])multi.values()).isEqualTo((Object)this.multiValue);
    }

    @Test
    void addShouldThrowIfAskedForChanged() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> ((IndexEntryUpdate)single).beforeValues());
    }

    @Test
    void removeShouldThrowIfAskedForChanged() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> ((IndexEntryUpdate)single).beforeValues());
    }

    @Test
    void updatesShouldEqualRegardlessOfCreationMethod() {
        IndexEntryUpdate singleAdd = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Value[] singleAsArray = new Value[]{this.singleValue};
        IndexEntryUpdate multiAdd = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleRemove = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multiRemove = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)this.singleValue);
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray, (Value[])singleAsArray);
        Assertions.assertThat((Object)singleAdd).isEqualTo((Object)multiAdd);
        Assertions.assertThat((Object)singleRemove).isEqualTo((Object)multiRemove);
        Assertions.assertThat((Object)singleChange).isEqualTo((Object)multiChange);
    }

    @Test
    void changedShouldRetainValues() {
        Value singleAfter = Values.of((Object)"Hello");
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)singleAfter);
        Object[] multiAfter = new Value[]{Values.of((Object)"Hello"), Values.of((Object)"Hi")};
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue, (Value[])multiAfter);
        Assertions.assertThat((Object[])new Object[]{this.singleValue}).isEqualTo((Object)singleChange.beforeValues());
        Assertions.assertThat((Object[])new Object[]{singleAfter}).isEqualTo((Object)singleChange.values());
        Assertions.assertThat((Object[])this.multiValue).isEqualTo((Object)multiChange.beforeValues());
        Assertions.assertThat((Object[])multiAfter).isEqualTo((Object)multiChange.values());
    }
}

