/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.time.Instant;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.DetachedCheckpointLogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class DetachedCheckpointLogEntryWriterTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    DetachedCheckpointLogEntryWriterTest() {
    }

    @Test
    void detachedCheckpointEntryHasSpecificLength() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("a"));
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryWriter checkpointLogEntryWriter = new DetachedCheckpointLogEntryWriter((WritableChecksumChannel)writeChannel);
                long initialPosition = writeChannel.position();
                DetachedCheckpointLogEntryWriterTest.writeCheckpoint(checkpointLogEntryWriter, "checkpoint reason");
                Assertions.assertThat((long)(writeChannel.position() - initialPosition)).isEqualTo(192L);
            }
        }
    }

    @Test
    void anyCheckpointEntryHaveTheSameSize() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("b"));
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryWriter checkpointLogEntryWriter = new DetachedCheckpointLogEntryWriter((WritableChecksumChannel)writeChannel);
                for (int i = 0; i < 100; ++i) {
                    long initialPosition = writeChannel.position();
                    DetachedCheckpointLogEntryWriterTest.writeCheckpoint(checkpointLogEntryWriter, RandomStringUtils.randomAlphabetic((int)10, (int)512));
                    long recordLength = writeChannel.position() - initialPosition;
                    Assertions.assertThat((long)recordLength).isEqualTo(192L);
                }
            }
        }
    }

    @Test
    void longCheckpointReasonIsTrimmedToFit() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("b"));
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryWriter checkpointLogEntryWriter = new DetachedCheckpointLogEntryWriter((WritableChecksumChannel)writeChannel);
                long initialPosition = writeChannel.position();
                DetachedCheckpointLogEntryWriterTest.writeCheckpoint(checkpointLogEntryWriter, StringUtils.repeat((String)"b", (int)1024));
                long recordLength = writeChannel.position() - initialPosition;
                Assertions.assertThat((long)recordLength).isEqualTo(192L);
            }
        }
    }

    private static void writeCheckpoint(DetachedCheckpointLogEntryWriter checkpointLogEntryWriter, String reason) throws IOException {
        StoreId storeId = new StoreId(3L, 4L, 5L, 6L, 7L);
        LogPosition logPosition = new LogPosition(1L, 2L);
        checkpointLogEntryWriter.writeCheckPointEntry(logPosition, Instant.ofEpochMilli(1L), storeId, reason);
    }
}

