/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class PhysicalLogicalTransactionStoreTest {
    private static final Health DATABASE_HEALTH = (Health)Mockito.mock(DatabaseHealth.class);
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    private Path databaseDirectory;
    private final Monitors monitors = new Monitors();

    PhysicalLogicalTransactionStoreTest() {
    }

    @BeforeEach
    void setup() {
        this.databaseDirectory = this.testDirectory.homePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void extractTransactionFromLogFilesSkippingLastLogFileWithoutHeader() throws IOException {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = this.buildLogFiles(transactionIdStore);
        life.add((Lifecycle)logFiles);
        life.start();
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        LogFile logFile = logFiles.getLogFile();
        this.fileSystem.write(logFile.getLogFileForVersion(logFile.getHighestLogVersion() + 1L)).close();
        positionCache.clear();
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFiles, positionCache, TestLogEntryReader.logEntryReader(), this.monitors, true);
        this.verifyTransaction(positionCache, additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted, (LogicalTransactionStore)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldOpenCleanStore() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = this.buildLogFiles(transactionIdStore);
        life.add((Lifecycle)logFiles);
        life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, DATABASE_HEALTH));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldOpenAndRecoverExistingData() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = this.buildLogFiles(transactionIdStore);
        life.start();
        life.add((Lifecycle)logFiles);
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        life.add((Lifecycle)logFiles);
        AtomicBoolean recoveryPerformed = new AtomicBoolean();
        FakeRecoveryVisitor visitor = new FakeRecoveryVisitor(additionalHeader, 12345L, timeCommitted, latestCommittedTxWhenStarted);
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, positionCache, TestLogEntryReader.logEntryReader(), this.monitors, true);
        life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, DATABASE_HEALTH));
        CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.databaseDirectory, logFiles, (FileSystemAbstraction)this.fileSystem, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        life.add((Lifecycle)new TransactionLogsRecovery((RecoveryService)new TestRecoveryService(visitor, logFiles, (LogicalTransactionStore)txStore, recoveryPerformed), logPruner, (Lifecycle)new LifecycleAdapter(), (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class), ProgressReporter.SILENT, false, RecoveryStartupChecker.EMPTY_CHECKER, PageCacheTracer.NULL));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
        Assertions.assertEquals((int)1, (int)visitor.getVisitedTransactions());
        Assertions.assertTrue((boolean)recoveryPerformed.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldExtractMetadataFromExistingTransaction() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = this.buildLogFiles(transactionIdStore);
        life.start();
        life.add((Lifecycle)logFiles);
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        life.add((Lifecycle)logFiles);
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFiles, positionCache, TestLogEntryReader.logEntryReader(), this.monitors, true);
        life.start();
        try {
            this.verifyTransaction(positionCache, additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted, (LogicalTransactionStore)store);
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        Mockito.when((Object)logFiles.getLogFile()).thenReturn((Object)logFile);
        Mockito.when((Object)logFile.getReader((LogPosition)ArgumentMatchers.any(LogPosition.class))).thenThrow(new Throwable[]{new NoSuchFileException("mock")});
        TransactionMetadataCache cache = new TransactionMetadataCache();
        cache.cacheTransactionMetadata(10L, new LogPosition(2L, 130L), 100, System.currentTimeMillis());
        LifeSupport life = new LifeSupport();
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, cache, TestLogEntryReader.logEntryReader(), this.monitors, true);
        try {
            life.start();
            Assertions.assertThrows(NoSuchTransactionException.class, () -> PhysicalLogicalTransactionStoreTest.lambda$shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing$0((LogicalTransactionStore)txStore));
        }
        finally {
            life.shutdown();
        }
    }

    private LogFiles buildLogFiles(TransactionIdStore transactionIdStore) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withTransactionIdStore(transactionIdStore).withLogVersionRepository((LogVersionRepository)Mockito.mock(LogVersionRepository.class)).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
    }

    private void addATransactionAndRewind(LifeSupport life, LogFiles logFiles, TransactionMetadataCache positionCache, TransactionIdStore transactionIdStore, byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) throws IOException {
        TransactionAppender appender = (TransactionAppender)life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, transactionIdStore, DATABASE_HEALTH));
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.singleTestCommand());
        transaction.setHeader(additionalHeader, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1, AuthSubject.ANONYMOUS);
        appender.append(new TransactionToApply((TransactionRepresentation)transaction, PageCursorTracer.NULL), LogAppendEvent.NULL);
    }

    private Collection<StorageCommand> singleTestCommand() {
        return Collections.singletonList(new TestCommand());
    }

    private void verifyTransaction(TransactionMetadataCache positionCache, byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, LogicalTransactionStore store) throws IOException {
        try (TransactionCursor cursor = store.getTransactions(2L);){
            boolean hasNext = cursor.next();
            Assertions.assertTrue((boolean)hasNext);
            CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)cursor.get();
            TransactionRepresentation transaction = tx.getTransactionRepresentation();
            Assertions.assertArrayEquals((byte[])additionalHeader, (byte[])transaction.additionalHeader());
            Assertions.assertEquals((long)timeStarted, (long)transaction.getTimeStarted());
            Assertions.assertEquals((long)timeCommitted, (long)transaction.getTimeCommitted());
            Assertions.assertEquals((long)latestCommittedTxWhenStarted, (long)transaction.getLatestCommittedTxWhenStarted());
        }
        positionCache.clear();
    }

    private static /* synthetic */ void lambda$shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing$0(LogicalTransactionStore txStore) throws Throwable {
        txStore.getTransactions(10L);
    }

    private static class TestRecoveryService
    implements RecoveryService {
        private final FakeRecoveryVisitor visitor;
        private final LogFiles logFiles;
        private final LogicalTransactionStore txStore;
        private final AtomicBoolean recoveryPerformed;

        TestRecoveryService(FakeRecoveryVisitor visitor, LogFiles logFiles, LogicalTransactionStore txStore, AtomicBoolean recoveryPerformed) {
            this.visitor = visitor;
            this.logFiles = logFiles;
            this.txStore = txStore;
            this.recoveryPerformed = recoveryPerformed;
        }

        public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, PageCursorTracer cursorTracer) {
            return mode == TransactionApplicationMode.REVERSE_RECOVERY ? (RecoveryApplier)Mockito.mock(RecoveryApplier.class) : this.visitor;
        }

        public RecoveryStartInformation getRecoveryStartInformation() throws IOException {
            return new RecoveryStartInformation(this.logFiles.getLogFile().extractHeader(0L).getStartPosition(), 1L);
        }

        public TransactionCursor getTransactions(LogPosition position) throws IOException {
            return this.txStore.getTransactions(position);
        }

        public TransactionCursor getTransactionsInReverseOrder(LogPosition position) throws IOException {
            return this.txStore.getTransactionsInReverseOrder(position);
        }

        public void transactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition lastTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, boolean missingLogs, PageCursorTracer cursorTracer) {
            this.recoveryPerformed.set(true);
        }
    }

    private static class FakeRecoveryVisitor
    implements RecoveryApplier {
        private final byte[] additionalHeader;
        private final long timeStarted;
        private final long timeCommitted;
        private final long latestCommittedTxWhenStarted;
        private int visitedTransactions;

        FakeRecoveryVisitor(byte[] additionalHeader, long timeStarted, long timeCommitted, long latestCommittedTxWhenStarted) {
            this.additionalHeader = additionalHeader;
            this.timeStarted = timeStarted;
            this.timeCommitted = timeCommitted;
            this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        }

        public boolean visit(CommittedTransactionRepresentation tx) {
            TransactionRepresentation transaction = tx.getTransactionRepresentation();
            Assertions.assertArrayEquals((byte[])this.additionalHeader, (byte[])transaction.additionalHeader());
            Assertions.assertEquals((long)this.timeStarted, (long)transaction.getTimeStarted());
            Assertions.assertEquals((long)this.timeCommitted, (long)transaction.getTimeCommitted());
            Assertions.assertEquals((long)this.latestCommittedTxWhenStarted, (long)transaction.getLatestCommittedTxWhenStarted());
            ++this.visitedTransactions;
            return false;
        }

        int getVisitedTransactions() {
            return this.visitedTransactions;
        }

        public void close() {
        }
    }
}

