/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class DetachedCheckpointAppenderTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    private final long rotationThreshold = ByteUnit.mebiBytes((long)1L);
    private final DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(2L, 0, 0L, 0L, 0L);
    private CheckpointAppender checkpointAppender;
    private LogFiles logFiles;

    DetachedCheckpointAppenderTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logFiles = this.buildLogFiles();
        this.life.add((Lifecycle)this.logFiles);
        this.life.start();
        this.checkpointAppender = this.logFiles.getCheckpointFile().getCheckpointAppender();
    }

    @Test
    void detachedCheckpointAppenderUsedForSeparateCheckpointFiles() {
        Assertions.assertThat((Object)this.checkpointAppender).isInstanceOf(DetachedCheckpointAppender.class);
    }

    @Test
    void failToWriteCheckpointOnUnhealthyDatabase() {
        this.databaseHealth.panic((Throwable)new RuntimeException("Panic"));
        LogPosition logPosition = new LogPosition(0L, 10L);
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> this.checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), "test"));
    }

    @Test
    void appendedCheckpointsCanBeLookedUpFromCheckpointFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        LogPosition logPosition1 = new LogPosition(0L, 10L);
        LogPosition logPosition2 = new LogPosition(0L, 20L);
        LogPosition logPosition3 = new LogPosition(0L, 30L);
        Assertions.assertThat((List)checkpointFile.reachableCheckpoints()).hasSize(0);
        this.checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition1, Instant.now(), "first");
        this.checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition2, Instant.now(), "second");
        this.checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition3, Instant.now(), "third");
        List checkpoints = checkpointFile.reachableCheckpoints();
        Assertions.assertThat((List)checkpoints).hasSize(3);
        Assertions.assertThat((Object)((CheckpointInfo)checkpoints.get(0))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)logPosition1);
        Assertions.assertThat((Object)((CheckpointInfo)checkpoints.get(1))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)logPosition2);
        Assertions.assertThat((Object)((CheckpointInfo)checkpoints.get(2))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)logPosition3);
    }

    private LogFiles buildLogFiles() throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withDatabaseHealth(this.databaseHealth).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
    }
}

