/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;

class TransactionLogFileInformationTest {
    private final LogFiles logFiles = (LogFiles)Mockito.mock(TransactionLogFiles.class);
    private final LogFile logFile = (LogFile)Mockito.mock(TransactionLogFile.class);
    private final LogHeaderCache logHeaderCache = (LogHeaderCache)Mockito.mock(LogHeaderCache.class);
    private final TransactionLogFilesContext context = (TransactionLogFilesContext)Mockito.mock(TransactionLogFilesContext.class);

    TransactionLogFileInformationTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)this.logFile);
    }

    @Test
    void shouldReadAndCacheFirstCommittedTransactionIdForAGivenVersionWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.getLogFile().versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logFiles.getLogFile().extractHeader(version)).thenReturn((Object)expectedHeader);
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache)).putHeader(version, expectedHeader);
    }

    @Test
    void shouldReadFirstCommittedTransactionIdForAGivenVersionWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)expectedHeader);
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    void shouldReadAndCacheFirstCommittedTransactionIdWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFile.versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logFile.extractHeader(version)).thenReturn((Object)expectedHeader);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache)).putHeader(version, expectedHeader);
    }

    @Test
    void shouldReadFirstCommittedTransactionIdWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFile.versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)expectedHeader);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    void shouldReturnNothingWhenThereAreNoTransactions() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)false);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)-1L, (long)firstCommittedTxId);
    }
}

