/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.memory.OptionalMemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.test.FakeCpuClock;
import org.neo4j.test.FakeMemoryTracker;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class ExecutingQueryTest {
    private final FakeClock clock = Clocks.fakeClock((TemporalAccessor)ZonedDateTime.parse("2016-12-03T15:10:00+01:00"));
    private final FakeCpuClock cpuClock = new FakeCpuClock().add(ExecutingQueryTest.randomLong(0x100000000L));
    private final PageCursorCountersStub page = new PageCursorCountersStub();
    private final ExecutingQuery query = this.createExecutingQuery(1, "hello world", this.page, this.clock, this.cpuClock);
    private long lockCount;

    ExecutingQueryTest() {
    }

    @Test
    void shouldReportElapsedTime() {
        this.clock.forward(10L, TimeUnit.MILLISECONDS);
        long elapsedTime = this.query.snapshot().elapsedTimeMicros();
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)elapsedTime);
    }

    @Test
    void shouldTransitionBetweenStates() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"parsing", (Object)this.query.snapshot().status());
        this.query.onObfuscatorReady(null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"planned", (Object)this.query.snapshot().status());
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        try (LockWaitEvent ignored = this.lock("NODE", 17L);){
            org.junit.jupiter.api.Assertions.assertEquals((Object)"waiting", (Object)this.query.snapshot().status());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
    }

    @Test
    void shouldReportPlanningTime() {
        this.clock.forward(124L, TimeUnit.MICROSECONDS);
        this.query.onObfuscatorReady(null);
        QuerySnapshot snapshot = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)snapshot.compilationTimeMicros(), (long)snapshot.elapsedTimeMicros());
        this.clock.forward(16L, TimeUnit.MICROSECONDS);
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        this.clock.forward(200L, TimeUnit.MICROSECONDS);
        snapshot = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)140L, (long)snapshot.compilationTimeMicros());
        org.junit.jupiter.api.Assertions.assertEquals((long)340L, (long)snapshot.elapsedTimeMicros());
    }

    @Test
    void shouldReportWaitTime() {
        QuerySnapshot snapshot;
        this.query.onObfuscatorReady(null);
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.clock.forward(10L, TimeUnit.SECONDS);
        try (LockWaitEvent ignored = this.lock("NODE", 17L);){
            this.clock.forward(5L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"waiting", (Object)snapshot.status());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)snapshot.resourceInformation()).containsEntry((Object)"waitTimeMillis", (Object)5000L)).containsEntry((Object)"resourceType", (Object)"NODE")).containsEntry((Object)"transactionId", (Object)10L)).containsEntry((Object)"resourceIds", (Object)new long[]{17L});
            org.junit.jupiter.api.Assertions.assertEquals((long)5000000L, (long)snapshot.waitTimeMicros());
        }
        QuerySnapshot snapshot2 = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)snapshot2.status());
        org.junit.jupiter.api.Assertions.assertEquals((long)5000000L, (long)snapshot2.waitTimeMicros());
        this.clock.forward(2L, TimeUnit.SECONDS);
        ignored = this.lock("RELATIONSHIP", 612L);
        try {
            this.clock.forward(1L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"waiting", (Object)snapshot.status());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)snapshot.resourceInformation()).containsEntry((Object)"waitTimeMillis", (Object)1000L)).containsEntry((Object)"resourceType", (Object)"RELATIONSHIP")).containsEntry((Object)"transactionId", (Object)10L)).containsEntry((Object)"resourceIds", (Object)new long[]{612L});
            org.junit.jupiter.api.Assertions.assertEquals((long)6000000L, (long)snapshot.waitTimeMicros());
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        snapshot2 = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)snapshot2.status());
        org.junit.jupiter.api.Assertions.assertEquals((long)6000000L, (long)snapshot2.waitTimeMicros());
    }

    @Test
    void shouldReportCpuTime() {
        this.cpuClock.add(60L, TimeUnit.MICROSECONDS);
        long cpuTime = this.query.snapshot().cpuTimeMicros().getAsLong();
        org.junit.jupiter.api.Assertions.assertEquals((long)60L, (long)cpuTime);
    }

    @Test
    void shouldNotReportCpuTimeIfUnavailable() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, TestDatabaseIdRepository.randomNamedDatabaseId(), "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, () -> 0L, () -> 1L, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, true);
        QuerySnapshot snapshot = query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((Object)snapshot.cpuTimeMicros(), (Object)OptionalLong.empty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)snapshot.idleTimeMicros(), (Object)OptionalLong.empty());
    }

    @Test
    void shouldNotReportHeapAllocationIfNotTracked() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, TestDatabaseIdRepository.randomNamedDatabaseId(), "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, () -> 0L, () -> 1L, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, false);
        QuerySnapshot snapshot = query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)snapshot.allocatedBytes());
    }

    @Test
    void shouldReportZeroHeapAllocationIfTracked() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, TestDatabaseIdRepository.randomNamedDatabaseId(), "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, () -> 0L, () -> 1L, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, true);
        QuerySnapshot snapshot = query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)snapshot.allocatedBytes());
    }

    @Test
    void shouldReportLockCount() {
        this.lockCount = 11L;
        org.junit.jupiter.api.Assertions.assertEquals((long)11L, (long)this.query.snapshot().activeLockCount());
        this.lockCount = 2L;
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)this.query.snapshot().activeLockCount());
    }

    @Test
    void shouldReportPageHitsAndFaults() {
        this.page.hits(7L);
        this.page.faults(3L);
        QuerySnapshot snapshot = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)snapshot.pageHits());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)snapshot.pageFaults());
        this.page.hits(2L);
        this.page.faults(5L);
        snapshot = this.query.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)9L, (long)snapshot.pageHits());
        org.junit.jupiter.api.Assertions.assertEquals((long)8L, (long)snapshot.pageFaults());
    }

    @Test
    void includeQueryExecutorThreadName() {
        String queryDescription = this.query.toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)queryDescription.contains("threadExecutingTheQueryName=" + Thread.currentThread().getName()));
    }

    @Test
    void shouldNotAllowCompletingCompilationMultipleTimes() {
        this.query.onObfuscatorReady(null);
        this.query.onCompilationCompleted(null, null, null);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.query.onCompilationCompleted(null, null, null));
    }

    @Test
    void shouldNotAllowStartingExecutionWithoutCompilation() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.query.onExecutionStarted(null));
    }

    @Test
    void shouldAllowRetryingAfterStartingExecutiong() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"parsing", (Object)this.query.snapshot().status());
        this.query.onObfuscatorReady(null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
        this.query.onCompilationCompleted(null, null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"planned", (Object)this.query.snapshot().status());
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.query.onRetryAttempted();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"parsing", (Object)this.query.snapshot().status());
    }

    @Test
    void shouldNotAllowRetryingWithoutStartingExecuting() {
        this.query.onObfuscatorReady(null);
        this.query.onCompilationCompleted(null, null, null);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((ExecutingQuery)this.query).onRetryAttempted());
    }

    private LockWaitEvent lock(String resourceType, long resourceId) {
        return this.query.lockTracer().waitForLock(LockType.SHARED, ExecutingQueryTest.resourceType(resourceType), 10L, new long[]{resourceId});
    }

    static ResourceType resourceType(final String name) {
        return new ResourceType(){

            public String toString() {
                return this.name();
            }

            public int typeId() {
                throw new UnsupportedOperationException("not used");
            }

            public WaitStrategy waitStrategy() {
                throw new UnsupportedOperationException("not used");
            }

            public String name() {
                return name;
            }
        };
    }

    private static long randomLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    private ExecutingQuery createExecutingQuery(int queryId, String hello_world, PageCursorCountersStub page, FakeClock clock, FakeCpuClock cpuClock) {
        return this.createExecutingQuery(queryId, hello_world, page, clock, cpuClock, TestDatabaseIdRepository.randomNamedDatabaseId(), VirtualValues.EMPTY_MAP);
    }

    private ExecutingQuery createExecutingQuery(int queryId, String hello_world, PageCursorCountersStub page, FakeClock clock, FakeCpuClock cpuClock, NamedDatabaseId dbID, MapValue params) {
        return new ExecutingQuery((long)queryId, ClientConnectionInfo.EMBEDDED_CONNECTION, dbID, "neo4j", hello_world, params, Collections.emptyMap(), () -> this.lockCount, page::hits, page::faults, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)clock, (CpuClock)cpuClock, true);
    }

    private static class PageCursorCountersStub
    implements PageCursorCounters {
        private long faults;
        private long pins;
        private long unpins;
        private long hits;
        private long bytesRead;
        private long evictions;
        private long evictionExceptions;
        private long bytesWritten;
        private long flushes;

        private PageCursorCountersStub() {
        }

        public long faults() {
            return this.faults;
        }

        public void faults(long increment) {
            this.faults += increment;
        }

        public long pins() {
            return this.pins;
        }

        public void pins(long increment) {
            this.pins += increment;
        }

        public long unpins() {
            return this.unpins;
        }

        public void unpins(long increment) {
            this.unpins += increment;
        }

        public long hits() {
            return this.hits;
        }

        public void hits(long increment) {
            this.hits += increment;
        }

        public long bytesRead() {
            return this.bytesRead;
        }

        public void bytesRead(long increment) {
            this.bytesRead += increment;
        }

        public long evictions() {
            return this.evictions;
        }

        public void evictions(long increment) {
            this.evictions += increment;
        }

        public long evictionExceptions() {
            return this.evictionExceptions;
        }

        public void evictionExceptions(long increment) {
            this.evictionExceptions += increment;
        }

        public long bytesWritten() {
            return this.bytesWritten;
        }

        public void bytesWritten(long increment) {
            this.bytesWritten += increment;
        }

        public long flushes() {
            return this.flushes;
        }

        public long merges() {
            return 0L;
        }

        public void flushes(long increment) {
            this.flushes += increment;
        }

        public double hitRatio() {
            return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
        }
    }
}

