/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.Clocks;
import org.neo4j.values.virtual.MapValue;

class KernelStatementTest {
    private final AtomicReference<CpuClock> cpuClockRef = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);

    KernelStatementTest() {
    }

    @Test
    void shouldReleaseResourcesWhenForceClosed() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.isSuccess()).thenReturn((Object)true);
        KernelStatement statement = this.createStatement(transaction);
        statement.acquire();
        Assertions.assertThrows(KernelStatement.StatementNotClosedException.class, () -> ((KernelStatement)statement).forceClose());
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatementResources();
    }

    @Test
    void assertStatementIsNotOpenWhileAcquireIsNotInvoked() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelStatement statement = this.createStatement(transaction);
        Assertions.assertThrows(NotInTransactionException.class, () -> ((KernelStatement)statement).assertOpen());
    }

    @Test
    void reportQueryWaitingTimeToTransactionStatisticWhenFinishQueryExecution() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelTransactionImplementation.Statistics statistics = new KernelTransactionImplementation.Statistics(transaction, this.cpuClockRef, false);
        Mockito.when((Object)transaction.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)transaction.executingQuery()).thenReturn(Optional.empty());
        KernelStatement statement = this.createStatement(transaction);
        statement.acquire();
        ExecutingQuery query = KernelStatementTest.getQueryWithWaitingTime();
        ExecutingQuery query2 = KernelStatementTest.getQueryWithWaitingTime();
        ExecutingQuery query3 = KernelStatementTest.getQueryWithWaitingTime();
        statement.stopQueryExecution(query);
        statement.stopQueryExecution(query2);
        statement.stopQueryExecution(query3);
        Assertions.assertEquals((long)3L, (long)statistics.getWaitingTimeNanos(1L));
    }

    @Test
    void emptyPageCacheStatisticOnClosedStatement() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        try (KernelStatement statement = this.createStatement(transaction);){
            CursorContext cursorContext = new CursorContext((PageCursorTracer)new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test"));
            statement.initialize((Locks.Client)Mockito.mock(Locks.Client.class), cursorContext, 100L);
            statement.acquire();
            cursorContext.getCursorTracer().beginPin(false, 1L, null).hit();
            cursorContext.getCursorTracer().beginPin(false, 1L, null).hit();
            cursorContext.getCursorTracer().beginPin(false, 1L, null).beginPageFault(1L, 2).done();
            Assertions.assertEquals((long)2L, (long)statement.getHits());
            Assertions.assertEquals((long)1L, (long)statement.getFaults());
            statement.close();
            Assertions.assertEquals((long)0L, (long)statement.getHits());
            Assertions.assertEquals((long)0L, (long)statement.getFaults());
        }
    }

    @Test
    void trackSequentialQueriesInStatement() {
        ExecutingQueryFactory queryFactory = new ExecutingQueryFactory(Clocks.nanoClock(), this.cpuClockRef, Config.defaults());
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        KernelStatement statement = this.createStatement(transaction);
        statement.initialize((Locks.Client)Mockito.mock(Locks.Client.class), CursorContext.NULL, 100L);
        ExecutingQuery query1 = queryFactory.createForStatement(statement, "test1", MapValue.EMPTY);
        ExecutingQuery query2 = queryFactory.createForStatement(statement, "test2", MapValue.EMPTY);
        ExecutingQuery query3 = queryFactory.createForStatement(statement, "test3", MapValue.EMPTY);
        statement.startQueryExecution(query1);
        statement.startQueryExecution(query2);
        Assertions.assertSame((Object)query2, statement.executingQuery().orElseThrow());
        statement.startQueryExecution(query3);
        Assertions.assertSame((Object)query3, statement.executingQuery().orElseThrow());
        statement.stopQueryExecution(query3);
        Assertions.assertSame((Object)query2, statement.executingQuery().orElseThrow());
        statement.stopQueryExecution(query2);
        Assertions.assertSame((Object)query1, statement.executingQuery().orElseThrow());
        statement.stopQueryExecution(query1);
        Assertions.assertFalse((boolean)statement.executingQuery().isPresent());
    }

    private KernelStatement createStatement(KernelTransactionImplementation transaction) {
        return new KernelStatement(transaction, LockTracer.NONE, new ClockContext(), this.cpuClockRef, new TestDatabaseIdRepository().defaultDatabase(), Config.defaults((Setting)GraphDatabaseInternalSettings.track_tx_statement_close, (Object)true));
    }

    private static ExecutingQuery getQueryWithWaitingTime() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.reportedWaitingTimeNanos()).thenReturn((Object)1L);
        return executingQuery;
    }
}

