/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.api.state.EntityStateImpl;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.values.storable.Values;

class EntityStateImplTest {
    EntityStateImplTest() {
    }

    @Test
    void shouldListAddedProperties() {
        EntityStateImpl state = new EntityStateImpl(1L, OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        state.addProperty(1, Values.of((Object)"Hello"));
        state.addProperty(2, Values.of((Object)"Hello"));
        state.removeProperty(1);
        Iterator added = state.addedProperties();
        Assertions.assertThat((List)Iterators.asList((Iterator)added)).isEqualTo(Arrays.asList(new PropertyKeyValue(2, Values.of((Object)"Hello"))));
    }

    @Test
    void shouldListAddedPropertiesEvenIfPropertiesHaveBeenReplaced() {
        EntityStateImpl state = new EntityStateImpl(1L, OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        state.addProperty(1, Values.of((Object)"Hello"));
        state.addProperty(1, Values.of((Object)"WAT"));
        state.addProperty(2, Values.of((Object)"Hello"));
        Iterator added = state.addedProperties();
        Assertions.assertThat((List)Iterators.asList((Iterator)added)).isEqualTo(Arrays.asList(new PropertyKeyValue(1, Values.of((Object)"WAT")), new PropertyKeyValue(2, Values.of((Object)"Hello"))));
    }

    @Test
    void shouldConvertAddRemoveToChange() {
        EntityStateImpl state = new EntityStateImpl(1L, OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        state.removeProperty(4);
        state.addProperty(4, Values.of((Object)"another value"));
        Assertions.assertThat((List)Iterators.asList((Iterator)state.changedProperties())).isEqualTo(Arrays.asList(new PropertyKeyValue(4, Values.of((Object)"another value"))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)state.addedProperties().hasNext());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)state.removedProperties().isEmpty());
    }
}

