/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeValueIndexUtility;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

public class FullScanNonUniqueIndexSamplerTest
extends IndexTestUtil<GenericKey, NativeIndexValue, IndexLayout<GenericKey, NativeIndexValue>> {
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)42, (int[])new int[]{666})).withName("index").materialise(0L);
    NativeValueIndexUtility<GenericKey, NativeIndexValue> valueUtil;
    ValueCreatorUtil<GenericKey, NativeIndexValue> valueCreatorUtil;

    @BeforeEach
    void setupValueCreator() {
        this.valueCreatorUtil = FullScanNonUniqueIndexSamplerTest.createValueCreatorUtil();
        this.valueUtil = new NativeValueIndexUtility<GenericKey, NativeIndexValue>(this.valueCreatorUtil, this.layout);
    }

    @Test
    void shouldIncludeAllValuesInTree() throws Exception {
        IndexSample sample;
        Value[] values = this.generateNumberValues();
        this.buildTree(values);
        try (GBPTree gbpTree = this.getTree();){
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, (IndexLayout)this.layout);
            sample = sampler.sample(CursorContext.NULL);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)values.length, (long)sample.sampleSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(values), (long)sample.uniqueValues());
        org.junit.jupiter.api.Assertions.assertEquals((long)values.length, (long)sample.indexSize());
    }

    @Test
    void tracePageCacheAccessOnSampling() throws IOException {
        Value[] values = this.generateNumberValues();
        this.buildTree(values);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("testTracer"));
        FullScanNonUniqueIndexSamplerTest.assertZeroCursor(cursorContext);
        try (GBPTree gbpTree = this.getTree();){
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, (IndexLayout)this.layout);
            sampler.sample(cursorContext);
        }
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorTracer.faults()).isEqualTo(1L);
    }

    private static void assertZeroCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }

    private Value[] generateNumberValues() {
        ValueType[] numberTypes = RandomValues.including(t -> t.valueGroup == ValueGroup.NUMBER);
        int size = 20;
        NumberValue[] result = new NumberValue[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.random.randomValues().nextValueOfTypes(numberTypes);
        }
        return result;
    }

    private void buildTree(Value[] values) throws IOException {
        try (GBPTree gbpTree = this.getTree();){
            try (Writer writer = gbpTree.writer(CursorContext.NULL);){
                GenericKey key = (GenericKey)((IndexLayout)this.layout).newKey();
                NativeIndexValue value = ((IndexLayout)this.layout).newValue();
                long nodeId = 0L;
                for (Value number : values) {
                    key.initialize(nodeId);
                    key.initFromValue(0, number, NativeIndexKey.Inclusion.NEUTRAL);
                    value.from(new Value[]{number});
                    writer.put((Object)key, (Object)value);
                    ++nodeId;
                }
            }
            gbpTree.checkpoint(CursorContext.NULL);
        }
    }

    private static ValueCreatorUtil<GenericKey, NativeIndexValue> createValueCreatorUtil() {
        return new ValueCreatorUtil<GenericKey, NativeIndexValue>(index, RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), 0.1);
    }

    @Override
    IndexFiles createIndexFiles(FileSystemAbstraction fs, TestDirectory directory, IndexDescriptor indexDescriptor) {
        IndexDirectoryStructure indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)directory.directory("root")).forProvider(indexDescriptor.getIndexProvider());
        return new IndexFiles.Directory(fs, indexDirectoryStructure, indexDescriptor.getId());
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return index;
    }

    @Override
    IndexLayout<GenericKey, NativeIndexValue> createLayout() {
        return new GenericLayout(1, specificSettings);
    }
}

