/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@PageCacheExtension
class GenericNativeIndexAccessorTest {
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;

    GenericNativeIndexAccessorTest() {
    }

    @Test
    void dropShouldDeleteEntireIndexFolder() {
        Path root = this.testDirectory.directory("root");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)root).forProvider(GenericNativeIndexProvider.DESCRIPTOR);
        long indexId = 8L;
        IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(indexId);
        IndexSpecificSpaceFillingCurveSettings spatialSettings = (IndexSpecificSpaceFillingCurveSettings)Mockito.mock(IndexSpecificSpaceFillingCurveSettings.class);
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, descriptor.getId());
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        GenericNativeIndexAccessor accessor = new GenericNativeIndexAccessor(databaseIndexContext, (IndexFiles)indexFiles, (IndexLayout)new GenericLayout(1, spatialSettings), RecoveryCleanupWorkCollector.immediate(), descriptor, spatialSettings, (SpaceFillingCurveConfiguration)Mockito.mock(SpaceFillingCurveConfiguration.class), SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        accessor.drop();
        Assertions.assertFalse((boolean)this.fs.fileExists(indexFiles.getBase()));
    }
}

