/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockWaitStrategies;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.time.Clocks;
import org.neo4j.util.concurrent.BinaryLatch;

@ExtendWith(value={RandomExtension.class})
class ForsetiFalseDeadlockTest {
    private static final int TEST_RUNS = 10;
    private static final ExecutorService executor = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });
    @Inject
    RandomRule random;

    ForsetiFalseDeadlockTest() {
    }

    @AfterAll
    static void tearDown() {
        executor.shutdown();
    }

    @TestFactory
    Stream<DynamicTest> testMildlyForFalseDeadlocks() {
        ThrowingConsumer fixtureConsumer = fixture -> ForsetiFalseDeadlockTest.loopRunTest(fixture, 10);
        return DynamicTest.stream(ForsetiFalseDeadlockTest.fixtures(), Fixture::toString, (ThrowingConsumer)fixtureConsumer);
    }

    @Test
    void shouldManageToTakeSortedLocksWithoutFalseDeadlocks() throws Throwable {
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, (Object)true);
        ForsetiLockManager manager = new ForsetiLockManager(config, Clocks.nanoClock(), (ResourceType[])ResourceTypes.values());
        AtomicInteger txCount = new AtomicInteger();
        AtomicInteger numDeadlocks = new AtomicInteger();
        Race race = new Race().withEndCondition(new BooleanSupplier[]{() -> txCount.get() > 10000});
        race.addContestants(Integer.max(Runtime.getRuntime().availableProcessors(), 2), Race.throwing(() -> {
            try (Locks.Client client = manager.newClient();){
                int txId = txCount.incrementAndGet();
                client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, (long)txId, (MemoryTracker)EmptyMemoryTracker.INSTANCE, config);
                long prevRel = this.random.nextInt(10);
                long nextRel = this.random.nextInt(10);
                long min = Math.min(prevRel, nextRel);
                long max = Math.max(prevRel, nextRel);
                client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{min});
                if (prevRel != nextRel) {
                    client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{max});
                }
                Thread.sleep(1L);
            }
            catch (DeadlockDetectedException e) {
                numDeadlocks.incrementAndGet();
            }
        }));
        race.go(3L, TimeUnit.MINUTES);
        Assertions.assertThat((int)numDeadlocks.get()).isLessThanOrEqualTo(3);
    }

    private static Iterator<Fixture> fixtures() {
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>();
        int iteration = 100;
        LockManager[] lockManagers = LockManager.values();
        LockWaitStrategies[] lockWaitStrategies = LockWaitStrategies.values();
        LockType[] lockTypes = LockType.values();
        for (LockManager lockManager : lockManagers) {
            for (LockWaitStrategies waitStrategy : lockWaitStrategies) {
                if (waitStrategy == LockWaitStrategies.NO_WAIT) continue;
                for (LockType lockTypeAX : lockTypes) {
                    for (LockType lockTypeAY : lockTypes) {
                        for (LockType lockTypeBX : lockTypes) {
                            for (LockType lockTypeBY : lockTypes) {
                                fixtures.add(new Fixture(iteration, lockManager, (WaitStrategy)waitStrategy, lockTypeAX, lockTypeAY, lockTypeBX, lockTypeBY));
                            }
                        }
                    }
                }
            }
        }
        return fixtures.iterator();
    }

    private static void loopRunTest(Fixture fixture, int testRuns) {
        ArrayList<Throwable> exceptionList = new ArrayList<Throwable>();
        ForsetiFalseDeadlockTest.loopRun(fixture, testRuns, exceptionList);
        if (!exceptionList.isEmpty()) {
            int additionalRuns = testRuns * 99;
            ForsetiFalseDeadlockTest.loopRun(fixture, additionalRuns, exceptionList);
            double totalRuns = additionalRuns + testRuns;
            double failures = exceptionList.size();
            double failureRate = failures / totalRuns;
            if (failureRate > 0.02) {
                AssertionError error = new AssertionError((Object)("False deadlock failure rate of " + failureRate + " is greater than 2%"));
                for (Throwable th : exceptionList) {
                    ((Throwable)((Object)error)).addSuppressed(th);
                }
                throw error;
            }
        }
    }

    private static void loopRun(Fixture fixture, int testRuns, List<Throwable> exceptionList) {
        for (int i = 0; i < testRuns; ++i) {
            try {
                ForsetiFalseDeadlockTest.runTest(fixture);
                continue;
            }
            catch (Throwable th) {
                th.addSuppressed(new Exception("Failed at iteration " + i));
                exceptionList.add(th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(Fixture fixture) throws InterruptedException, ExecutionException {
        int iterations = fixture.iterations();
        ResourceType resourceType = fixture.createResourceType();
        try (Locks manager = fixture.createLockManager(resourceType);
             Locks.Client a = manager.newClient();
             Locks.Client b = manager.newClient();){
            a.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
            b.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 2L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
            BinaryLatch startLatch = new BinaryLatch();
            BlockedCallable callA = new BlockedCallable(startLatch, (ThrowingAction<Exception>)((ThrowingAction)() -> ForsetiFalseDeadlockTest.workloadA(fixture, a, resourceType, iterations)));
            BlockedCallable callB = new BlockedCallable(startLatch, (ThrowingAction<Exception>)((ThrowingAction)() -> ForsetiFalseDeadlockTest.workloadB(fixture, b, resourceType, iterations)));
            Future<Void> futureA = executor.submit(callA);
            Future<Void> futureB = executor.submit(callB);
            callA.awaitBlocked();
            callB.awaitBlocked();
            startLatch.release();
            futureA.get();
            futureB.get();
        }
    }

    private static void workloadA(Fixture fixture, Locks.Client a, ResourceType resourceType, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            fixture.acquireAX(a, resourceType);
            fixture.acquireAY(a, resourceType);
            fixture.releaseAY(a, resourceType);
            fixture.releaseAX(a, resourceType);
        }
    }

    private static void workloadB(Fixture fixture, Locks.Client b, ResourceType resourceType, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            fixture.acquireBX(b, resourceType);
            fixture.releaseBX(b, resourceType);
            fixture.acquireBY(b, resourceType);
            fixture.releaseBY(b, resourceType);
        }
    }

    public static enum LockManager {
        FORSETI{

            @Override
            public Locks create(ResourceType resourceType) {
                return new ForsetiLockManager(Config.defaults(), Clocks.nanoClock(), new ResourceType[]{resourceType});
            }
        };


        public abstract Locks create(ResourceType var1);
    }

    public static enum LockType {
        EXCLUSIVE{

            @Override
            public void acquire(Locks.Client client, ResourceType resourceType, int resource) {
                client.acquireExclusive(LockTracer.NONE, resourceType, new long[]{resource});
            }

            @Override
            public void release(Locks.Client client, ResourceType resourceType, int resource) {
                client.releaseExclusive(resourceType, new long[]{resource});
            }
        }
        ,
        SHARED{

            @Override
            public void acquire(Locks.Client client, ResourceType resourceType, int resource) {
                client.acquireShared(LockTracer.NONE, resourceType, new long[]{resource});
            }

            @Override
            public void release(Locks.Client client, ResourceType resourceType, int resource) {
                client.releaseShared(resourceType, new long[]{resource});
            }
        };


        public abstract void acquire(Locks.Client var1, ResourceType var2, int var3);

        public abstract void release(Locks.Client var1, ResourceType var2, int var3);
    }

    private static class Fixture {
        private final int iterations;
        private final LockManager lockManager;
        private final WaitStrategy waitStrategy;
        private final LockType lockTypeAX;
        private final LockType lockTypeAY;
        private final LockType lockTypeBX;
        private final LockType lockTypeBY;

        Fixture(int iterations, LockManager lockManager, WaitStrategy waitStrategy, LockType lockTypeAX, LockType lockTypeAY, LockType lockTypeBX, LockType lockTypeBY) {
            this.iterations = iterations;
            this.lockManager = lockManager;
            this.waitStrategy = waitStrategy;
            this.lockTypeAX = lockTypeAX;
            this.lockTypeAY = lockTypeAY;
            this.lockTypeBX = lockTypeBX;
            this.lockTypeBY = lockTypeBY;
        }

        int iterations() {
            return this.iterations;
        }

        Locks createLockManager(ResourceType resourceType) {
            return this.lockManager.create(resourceType);
        }

        ResourceType createResourceType() {
            return new ResourceType(){

                public int typeId() {
                    return 0;
                }

                public WaitStrategy waitStrategy() {
                    return waitStrategy;
                }

                public String name() {
                    return "MyTestResource";
                }
            };
        }

        void acquireAX(Locks.Client client, ResourceType resourceType) {
            this.lockTypeAX.acquire(client, resourceType, 1);
        }

        void releaseAX(Locks.Client client, ResourceType resourceType) {
            this.lockTypeAX.release(client, resourceType, 1);
        }

        void acquireAY(Locks.Client client, ResourceType resourceType) {
            this.lockTypeAY.acquire(client, resourceType, 2);
        }

        void releaseAY(Locks.Client client, ResourceType resourceType) {
            this.lockTypeAY.release(client, resourceType, 2);
        }

        void acquireBX(Locks.Client client, ResourceType resourceType) {
            this.lockTypeBX.acquire(client, resourceType, 1);
        }

        void releaseBX(Locks.Client client, ResourceType resourceType) {
            this.lockTypeBX.release(client, resourceType, 1);
        }

        void acquireBY(Locks.Client client, ResourceType resourceType) {
            this.lockTypeBY.acquire(client, resourceType, 2);
        }

        void releaseBY(Locks.Client client, ResourceType resourceType) {
            this.lockTypeBY.release(client, resourceType, 2);
        }

        public String toString() {
            return "iterations=" + this.iterations + ", lockManager=" + this.lockManager + ", waitStrategy=" + this.waitStrategy + ", lockTypeAX=" + this.lockTypeAX + ", lockTypeAY=" + this.lockTypeAY + ", lockTypeBX=" + this.lockTypeBX + ", lockTypeBY=" + this.lockTypeBY;
        }
    }

    private static class BlockedCallable
    implements Callable<Void> {
        private final BinaryLatch startLatch;
        private final ThrowingAction<Exception> delegate;
        private volatile Thread runner;

        BlockedCallable(BinaryLatch startLatch, ThrowingAction<Exception> delegate) {
            this.startLatch = startLatch;
            this.delegate = delegate;
        }

        @Override
        public Void call() throws Exception {
            this.runner = Thread.currentThread();
            this.startLatch.await();
            this.delegate.apply();
            return null;
        }

        void awaitBlocked() {
            Thread t;
            while ((t = this.runner) == null || t.getState() != Thread.State.WAITING) {
            }
        }
    }
}

