/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.time.Clocks;

@EphemeralTestDirectoryExtension
class ConfiguringPageCacheFactoryTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private JobScheduler jobScheduler;

    ConfiguringPageCacheFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldFitAsManyPagesAsItCan() {
        long pageCount = 60L;
        long memory = MuninnPageCache.memoryRequiredForPages((long)pageCount);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)Long.toString(memory));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools());
        try (PageCache cache = factory.getOrCreatePageCache();){
            Assertions.assertThat((int)cache.pageSize()).isEqualTo(8192);
            Assertions.assertThat((long)cache.maxCachedPages()).isEqualTo(pageCount);
        }
    }

    @Test
    void createPageCacheWithoutPreallocationEnabled() throws IOException {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.preallocate_store_files, (Object)false);
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools());
        Path testFile = this.testDirectory.createFile("a");
        try (PageCache cache = factory.getOrCreatePageCache();
             PagedFile file = cache.map(testFile, 8192, "foo");
             PageCursor io = file.io(1024L, 2, CursorContext.NULL);){
            int bigPageToExpand = 20021;
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> io.next((long)bigPageToExpand));
            org.junit.jupiter.api.Assertions.assertEquals((long)bigPageToExpand, (long)file.getLastPageId());
        }
    }
}

