/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.SimpleStageControl;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.GenerateIndexUpdatesStep;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.TestPropertyScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.lock.Lock;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class GenerateIndexUpdatesStepTest {
    private static final LongFunction<Lock> NO_LOCKING = id -> null;
    private static final int LABEL = 1;
    private static final int OTHER_LABEL = 2;
    private static final String KEY = "key";
    private static final String OTHER_KEY = "other_key";

    GenerateIndexUpdatesStepTest() {
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldSendSingleBatchIfBelowMaxSizeThreshold(boolean alsoWrite) throws Exception {
        StubStorageCursors data = GenerateIndexUpdatesStepTest.someUniformData(10);
        TestPropertyScanConsumer scanConsumer = new TestPropertyScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)scanConsumer, null, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            Assertions.assertThat(sender.batches).isEmpty();
            Assertions.assertThat((int)scanConsumer.batches.size()).isEqualTo(1);
            Assertions.assertThat((int)scanConsumer.batches.get(0).size()).isEqualTo(10);
        } else {
            Assertions.assertThat((int)sender.batches.size()).isEqualTo(1);
            Assertions.assertThat(scanConsumer.batches).isEmpty();
        }
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldSendBatchesOverMaxByteSizeThreshold(boolean alsoWrite) throws Exception {
        StubStorageCursors data = GenerateIndexUpdatesStepTest.someUniformData(10);
        TestPropertyScanConsumer scanConsumer = new TestPropertyScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)scanConsumer, null, NO_LOCKING, 1, 100L, alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            Assertions.assertThat((int)scanConsumer.batches.size()).isGreaterThan(1);
            Assertions.assertThat(sender.batches).isEmpty();
        } else {
            Assertions.assertThat(scanConsumer.batches).isEmpty();
            Assertions.assertThat((int)sender.batches.size()).isGreaterThan(1);
        }
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldGenerateEntityPropertyUpdates(boolean alsoWrite) throws Exception {
        StubStorageCursors data = GenerateIndexUpdatesStepTest.someUniformData(10);
        TestPropertyScanConsumer scanConsumer = new TestPropertyScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)scanConsumer, null, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        HashSet<TestPropertyScanConsumer.Record> expectedUpdates = new HashSet<TestPropertyScanConsumer.Record>();
        try (StorageNodeCursor cursor = data.allocateNodeCursor(CursorContext.NULL);
             StoragePropertyCursor propertyCursor = data.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            cursor.scan();
            while (cursor.next()) {
                cursor.properties(propertyCursor);
                HashMap<Integer, Value> properties = new HashMap<Integer, Value>();
                while (propertyCursor.next()) {
                    properties.put(propertyCursor.propertyKey(), propertyCursor.propertyValue());
                }
                expectedUpdates.add(new TestPropertyScanConsumer.Record(cursor.entityReference(), cursor.labels(), properties));
            }
        }
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            for (TestPropertyScanConsumer.Record update : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)expectedUpdates.remove(update)).isTrue();
            }
        } else {
            GenerateIndexUpdatesStep.GeneratedIndexUpdates updates = (GenerateIndexUpdatesStep.GeneratedIndexUpdates)sender.batches.get(0);
            updates.completeBatch();
            for (TestPropertyScanConsumer.Record update : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)expectedUpdates.remove(update)).isTrue();
            }
        }
        Assertions.assertThat(expectedUpdates).isEmpty();
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldGenerateEntityTokenUpdates(boolean alsoWrite) throws Exception {
        StubStorageCursors data = GenerateIndexUpdatesStepTest.someUniformData(10);
        TestTokenScanConsumer scanConsumer = new TestTokenScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, null, (TokenScanConsumer)scanConsumer, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        HashSet<TestTokenScanConsumer.Record> expectedUpdates = new HashSet<TestTokenScanConsumer.Record>();
        try (StorageNodeCursor cursor = data.allocateNodeCursor(CursorContext.NULL);){
            cursor.scan();
            while (cursor.next()) {
                expectedUpdates.add(new TestTokenScanConsumer.Record(cursor.entityReference(), cursor.labels()));
            }
        }
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            for (TestTokenScanConsumer.Record tokenUpdate : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)expectedUpdates.remove(tokenUpdate)).isTrue();
            }
        } else {
            GenerateIndexUpdatesStep.GeneratedIndexUpdates updates = (GenerateIndexUpdatesStep.GeneratedIndexUpdates)sender.batches.get(0);
            updates.completeBatch();
            for (TestTokenScanConsumer.Record tokenUpdate : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)expectedUpdates.remove(tokenUpdate)).isTrue();
            }
        }
        Assertions.assertThat(expectedUpdates).isEmpty();
    }

    @Test
    void shouldGenerateEntityPropertyUpdatesForRelevantEntityTokens() throws Exception {
        StubStorageCursors data = new StubStorageCursors();
        int numNodes = 10;
        MutableLongSet relevantNodeIds = LongSets.mutable.empty();
        for (int i = 0; i < numNodes; ++i) {
            int labelId = i % 2 == 0 ? 1 : 2;
            data.withNode(i).labels(labelId).properties(new Object[]{KEY, Values.stringValue((String)("name_" + i))});
            if (labelId != 1) continue;
            relevantNodeIds.add((long)i);
        }
        TestPropertyScanConsumer scanConsumer = new TestPropertyScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)scanConsumer, null, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), false, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        GenerateIndexUpdatesStep.GeneratedIndexUpdates updates = (GenerateIndexUpdatesStep.GeneratedIndexUpdates)sender.batches.get(0);
        updates.completeBatch();
        for (TestPropertyScanConsumer.Record update : scanConsumer.batches.get(0)) {
            Assertions.assertThat((boolean)relevantNodeIds.remove(update.getEntityId())).isTrue();
        }
        Assertions.assertThat((boolean)relevantNodeIds.isEmpty()).isTrue();
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldGenerateEntityPropertyUpdatesForRelevantPropertyTokens(boolean alsoWrite) throws Exception {
        StubStorageCursors data = new StubStorageCursors();
        int numNodes = 10;
        MutableLongSet relevantNodeIds = LongSets.mutable.empty();
        for (int i = 0; i < numNodes; ++i) {
            StubStorageCursors.NodeData node = data.withNode(i).labels(1L);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(KEY, Values.stringValue((String)("name_" + i)));
            if (i % 2 == 0) {
                properties.put(OTHER_KEY, Values.intValue((int)i));
                relevantNodeIds.add((long)i);
            }
            node.properties(properties);
        }
        int otherKeyId = data.propertyKeyTokenHolder().getIdByName(OTHER_KEY);
        TestPropertyScanConsumer scanConsumer = new TestPropertyScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, pid -> pid == otherKeyId, (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)scanConsumer, null, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            for (TestPropertyScanConsumer.Record update : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)relevantNodeIds.remove(update.getEntityId())).isTrue();
            }
        } else {
            GenerateIndexUpdatesStep.GeneratedIndexUpdates updates = (GenerateIndexUpdatesStep.GeneratedIndexUpdates)sender.batches.get(0);
            updates.completeBatch();
            for (TestPropertyScanConsumer.Record update : scanConsumer.batches.get(0)) {
                Assertions.assertThat((boolean)relevantNodeIds.remove(update.getEntityId())).isTrue();
            }
        }
        Assertions.assertThat((boolean)relevantNodeIds.isEmpty()).isTrue();
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldGenerateBothEntityTokenAndPropertyUpdates(boolean alsoWrite) throws Exception {
        int numNodes = 10;
        StubStorageCursors data = GenerateIndexUpdatesStepTest.someUniformData(numNodes);
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        TestTokenScanConsumer tokenScanConsumer = new TestTokenScanConsumer();
        GenerateIndexUpdatesStep step = new GenerateIndexUpdatesStep((StageControl)new SimpleStageControl(), Configuration.DEFAULT, (StorageReader)data, (IntPredicate)IntPredicates.alwaysTrue(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), new int[]{1}, (PropertyScanConsumer)propertyScanConsumer, (TokenScanConsumer)tokenScanConsumer, NO_LOCKING, 1, ByteUnit.mebiBytes((long)1L), alsoWrite, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CapturingBatchSender sender = new CapturingBatchSender();
        step.process(GenerateIndexUpdatesStepTest.allNodeIds(data), sender, CursorContext.NULL);
        if (alsoWrite) {
            Assertions.assertThat((int)propertyScanConsumer.batches.size()).isEqualTo(1);
            Assertions.assertThat((int)propertyScanConsumer.batches.get(0).size()).isEqualTo(numNodes);
            Assertions.assertThat((int)tokenScanConsumer.batches.size()).isEqualTo(1);
            Assertions.assertThat((int)tokenScanConsumer.batches.get(0).size()).isEqualTo(numNodes);
        } else {
            GenerateIndexUpdatesStep.GeneratedIndexUpdates updates = (GenerateIndexUpdatesStep.GeneratedIndexUpdates)sender.batches.get(0);
            updates.completeBatch();
            Assertions.assertThat((int)propertyScanConsumer.batches.size()).isEqualTo(1);
            Assertions.assertThat((int)propertyScanConsumer.batches.get(0).size()).isEqualTo(numNodes);
            Assertions.assertThat((int)tokenScanConsumer.batches.size()).isEqualTo(1);
            Assertions.assertThat((int)tokenScanConsumer.batches.get(0).size()).isEqualTo(numNodes);
        }
    }

    private static StubStorageCursors someUniformData(int numNodes) {
        StubStorageCursors data = new StubStorageCursors();
        for (int i = 0; i < numNodes; ++i) {
            data.withNode(i).labels(1L).properties(new Object[]{KEY, Values.stringValue((String)("name_" + i))});
        }
        return data;
    }

    private static long[] allNodeIds(StubStorageCursors data) {
        try (StorageNodeCursor cursor = data.allocateNodeCursor(CursorContext.NULL);){
            cursor.scan();
            MutableLongList ids = LongLists.mutable.empty();
            while (cursor.next()) {
                ids.add(cursor.entityReference());
            }
            long[] lArray = ids.toArray();
            return lArray;
        }
    }

    private static class CapturingBatchSender<T>
    implements BatchSender {
        private final List<T> batches = new ArrayList<T>();

        private CapturingBatchSender() {
        }

        public void send(Object batch) {
            this.batches.add(batch);
        }
    }
}

