/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.storageengine.api.StoreId;

class RecoveryStartInformationProviderTest {
    private static final long NO_TRANSACTION_ID = -1L;
    private final long currentLogVersion = 2L;
    private final long logVersion = 2L;
    private final LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
    private final RecoveryStartInformationProvider.Monitor monitor = (RecoveryStartInformationProvider.Monitor)Mockito.mock(RecoveryStartInformationProvider.Monitor.class);

    RecoveryStartInformationProviderTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        LogHeader logHeader = new LogHeader(0L, 1L, StoreId.UNKNOWN);
        Mockito.when((Object)this.logFile.extractHeader(0L)).thenReturn((Object)logHeader);
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)this.logFile);
    }

    @Test
    void shouldReturnUnspecifiedIfThereIsNoNeedForRecovery() {
        Mockito.when((Object)this.logFiles.getTailInformation()).thenReturn((Object)new LogTailInformation(false, -1L, false, 2L, KernelVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCommitsAfterLastCheckPoint(null);
        Assertions.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)-1L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertFalse((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void shouldReturnLogPositionToRecoverFromIfNeeded() {
        LogPosition checkPointLogPosition = new LogPosition(1L, 4242L);
        Mockito.when((Object)this.logFiles.getTailInformation()).thenReturn((Object)new LogTailInformation(new CheckpointInfo(checkPointLogPosition, StoreId.UNKNOWN, LogPosition.UNSPECIFIED), true, 10L, false, 2L, KernelVersion.LATEST.version(), StoreId.UNKNOWN));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).commitsAfterLastCheckPoint(checkPointLogPosition, 10L);
        Assertions.assertEquals((Object)checkPointLogPosition, (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void shouldRecoverFromStartOfLogZeroIfThereAreNoCheckPointAndOldestLogIsVersionZero() {
        Mockito.when((Object)this.logFiles.getTailInformation()).thenReturn((Object)new LogTailInformation(true, 10L, false, 2L, KernelVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCheckPointFound();
        Assertions.assertEquals((Object)new LogPosition(0L, 64L), (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void detectMissingTransactionLogsInformation() {
        Mockito.when((Object)this.logFiles.getTailInformation()).thenReturn((Object)new LogTailInformation(false, -1L, true, -1L, KernelVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.logFiles, this.monitor).get();
        Assertions.assertSame((Object)RecoveryStartInformation.MISSING_LOGS, (Object)recoveryStartInformation);
    }

    @Test
    void shouldFailIfThereAreNoCheckPointsAndOldestLogVersionInNotZero() {
        long oldestLogVersionFound = 1L;
        Mockito.when((Object)this.logFile.getLowestLogVersion()).thenReturn((Object)oldestLogVersionFound);
        Mockito.when((Object)this.logFiles.getTailInformation()).thenReturn((Object)new LogTailInformation(true, 10L, false, 2L, KernelVersion.LATEST.version()));
        UnderlyingStorageException storageException = (UnderlyingStorageException)Assertions.assertThrows(UnderlyingStorageException.class, () -> new RecoveryStartInformationProvider(this.logFiles, this.monitor).get());
        String expectedMessage = "No check point found in any log file from version " + oldestLogVersionFound + " to 2";
        Assertions.assertEquals((Object)expectedMessage, (Object)storageException.getMessage());
    }
}

