/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;

class RecoveryStartupCheckerTest {
    private final DatabaseStartupController startupController = (DatabaseStartupController)Mockito.mock(DatabaseStartupController.class);
    private final NamedDatabaseId namedDatabaseId = TestDatabaseIdRepository.randomNamedDatabaseId();

    RecoveryStartupCheckerTest() {
    }

    @Test
    void throwAboutExceptionOnShouldAbort() {
        RecoveryStartupChecker recoveryStartupChecker = new RecoveryStartupChecker(this.startupController, this.namedDatabaseId);
        Assertions.assertDoesNotThrow(() -> ((RecoveryStartupChecker)recoveryStartupChecker).checkIfCanceled());
        Mockito.when((Object)this.startupController.shouldAbort(this.namedDatabaseId)).thenReturn((Object)true);
        Assertions.assertThrows(DatabaseStartAbortedException.class, () -> ((RecoveryStartupChecker)recoveryStartupChecker).checkIfCanceled());
    }
}

