/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class NodeStateImplTest {
    @Inject
    private RandomRule random;

    NodeStateImplTest() {
    }

    @Test
    void shouldReportNoAddedRelationshipsOnNoRelationshipsAdded() {
        NodeStateImpl state = NodeStateImplTest.newNodeState();
        Assertions.assertThat((boolean)state.hasAddedRelationships()).isFalse();
    }

    @Test
    void shouldReportAddedRelationshipsOnRelationshipsAdded() {
        NodeStateImpl state = NodeStateImplTest.newNodeState();
        this.generateRandomRelationships().forEach(r -> state.addRelationship(r.id, r.type, r.direction));
        Assertions.assertThat((boolean)state.hasAddedRelationships()).isTrue();
    }

    @Test
    void shouldReportNoAddedRelationshipsOnRelationshipsFirstAddedThenRemoved() {
        NodeStateImpl state = NodeStateImplTest.newNodeState();
        List<AddedRelationship> relationships = this.generateRandomRelationships();
        relationships.forEach(r -> state.addRelationship(r.id, r.type, r.direction));
        relationships.forEach(r -> {
            Assertions.assertThat((boolean)state.hasAddedRelationships()).isTrue();
            state.removeRelationship(r.id, r.type, r.direction);
        });
        Assertions.assertThat((boolean)state.hasAddedRelationships()).isFalse();
    }

    private List<AddedRelationship> generateRandomRelationships() {
        Object[] possibleRelationshipDirections = new RelationshipDirection[]{RelationshipDirection.OUTGOING, RelationshipDirection.INCOMING, RelationshipDirection.LOOP};
        int count = this.random.nextInt(1, 10);
        ArrayList<AddedRelationship> relationships = new ArrayList<AddedRelationship>();
        for (int i = 0; i < count; ++i) {
            relationships.add(new AddedRelationship(this.random.nextLong(100000000L), this.random.nextInt(10), (RelationshipDirection)this.random.among(possibleRelationshipDirections)));
        }
        return relationships;
    }

    private static NodeStateImpl newNodeState() {
        return NodeStateImpl.createNodeState((long)99L, (boolean)false, (CollectionsFactory)OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static class AddedRelationship {
        private final long id;
        private final int type;
        private final RelationshipDirection direction;

        private AddedRelationship(long id, int type, RelationshipDirection direction) {
            this.id = id;
            this.type = type;
            this.direction = direction;
        }
    }
}

