/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.ValueType;

class NativeIndexAccessorTest
extends NativeIndexAccessorTests<GenericKey, NativeIndexValue> {
    private static final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final StandardConfiguration configuration = new StandardConfiguration();
    private static final IndexDescriptor indexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)42, (int[])new int[]{666})).withName("index").materialise(0L);
    private final ValueType[] supportedTypes = ValueType.values();
    private final IndexLayoutFactory<GenericKey, NativeIndexValue> indexLayoutFactory = () -> new GenericLayout(1, spaceFillingCurveSettings);
    private final IndexCapability indexCapability = GenericNativeIndexProvider.CAPABILITY;

    NativeIndexAccessorTest() {
    }

    NativeIndexAccessor<GenericKey, NativeIndexValue> createAccessor(PageCache pageCache) {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new GenericNativeIndexAccessor(context, this.indexFiles, (IndexLayout)this.layout, cleanup, indexDescriptor, spaceFillingCurveSettings, (SpaceFillingCurveConfiguration)configuration, this.tokenNameLookup);
    }

    @Override
    IndexCapability indexCapability() {
        return this.indexCapability;
    }

    @Override
    ValueCreatorUtil<GenericKey, NativeIndexValue> createValueCreatorUtil() {
        return new ValueCreatorUtil<GenericKey, NativeIndexValue>(indexDescriptor, this.supportedTypes, 0.1);
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return indexDescriptor;
    }

    @Override
    IndexLayout<GenericKey, NativeIndexValue> createLayout() {
        return this.indexLayoutFactory.create();
    }
}

