/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeValueIndexUtility;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Values;

abstract class NativeIndexPopulatorTests<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends IndexPopulatorTests<KEY, VALUE, IndexLayout<KEY, VALUE>> {
    private static final int LARGE_AMOUNT_OF_UPDATES = 1000;
    NativeValueIndexUtility<KEY, VALUE> valueUtil;
    ValueCreatorUtil<KEY, VALUE> valueCreatorUtil;

    NativeIndexPopulatorTests() {
    }

    @BeforeEach
    void setupValueCreator() {
        this.valueCreatorUtil = this.createValueCreatorUtil();
        this.valueUtil = new NativeValueIndexUtility<KEY, VALUE>(this.valueCreatorUtil, this.layout);
    }

    @Override
    IndexFiles createIndexFiles(FileSystemAbstraction fs, TestDirectory directory, IndexDescriptor indexDescriptor) {
        IndexDirectoryStructure indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)directory.directory("root")).forProvider(indexDescriptor.getIndexProvider());
        return new IndexFiles.Directory(fs, indexDirectoryStructure, indexDescriptor.getId());
    }

    @Override
    byte failureByte() {
        return 0;
    }

    @Override
    byte populatingByte() {
        return 2;
    }

    @Override
    byte onlineByte() {
        return 1;
    }

    abstract ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil();

    @Test
    void dropShouldDeleteExistingDirectory() throws IOException {
        this.populator.create();
        Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getBase()));
        this.populator.drop();
        Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()), (String)"expected drop to delete index base");
    }

    @Test
    void addShouldApplyAllUpdatesOnce() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.populator.add(Arrays.asList(updates), CursorContext.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void updaterShouldApplyUpdates() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void updaterMustThrowIfProcessAfterClose() throws Exception {
        this.populator.create();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);
        updater.close();
        Assertions.assertThrows(IllegalStateException.class, () -> updater.process(this.valueCreatorUtil.add(1L, Values.of((Object)Long.MAX_VALUE))));
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void shouldApplyInterleavedUpdatesFromAddAndUpdater() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.applyInterleaved((IndexEntryUpdate<IndexDescriptor>[])updates, this.populator);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void shouldApplyLargeAmountOfInterleavedRandomUpdates() throws Exception {
        this.populator.create();
        this.random.reset();
        Random updaterRandom = new Random(this.random.seed());
        Iterator<ValueIndexEntryUpdate<IndexDescriptor>> updates = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int count = this.interleaveLargeAmountOfUpdates(updaterRandom, updates);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.random.reset();
        this.verifyUpdates(this.valueCreatorUtil.randomUpdateGenerator(this.random), count);
    }

    private void verifyUpdates(Iterator<ValueIndexEntryUpdate<IndexDescriptor>> indexEntryUpdateIterator, int count) throws IOException {
        ValueIndexEntryUpdate[] updates = new ValueIndexEntryUpdate[count];
        for (int i = 0; i < count; ++i) {
            updates[i] = indexEntryUpdateIterator.next();
        }
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    void applyInterleaved(IndexEntryUpdate<IndexDescriptor>[] updates, IndexPopulator populator) throws IndexEntryConflictException {
        boolean useUpdater = true;
        ArrayList<IndexEntryUpdate<IndexDescriptor>> populatorBatch = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        IndexUpdater updater = populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            if (this.random.nextInt(100) < 20) {
                if (useUpdater) {
                    updater.close();
                    populatorBatch = new ArrayList();
                } else {
                    populator.add(populatorBatch, CursorContext.NULL);
                    updater = populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);
                }
                boolean bl = useUpdater = !useUpdater;
            }
            if (useUpdater) {
                updater.process(update);
                continue;
            }
            populatorBatch.add(update);
        }
        if (useUpdater) {
            updater.close();
        } else {
            populator.add(populatorBatch, CursorContext.NULL);
        }
    }

    int interleaveLargeAmountOfUpdates(Random updaterRandom, Iterator<? extends IndexEntryUpdate<IndexDescriptor>> updates) throws IndexEntryConflictException {
        int count = 0;
        for (int i = 0; i < 1000; ++i) {
            if ((double)updaterRandom.nextFloat() < 0.1) {
                try (IndexUpdater indexUpdater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);){
                    int numberOfUpdaterUpdates = updaterRandom.nextInt(100);
                    for (int j = 0; j < numberOfUpdaterUpdates; ++j) {
                        indexUpdater.process(updates.next());
                        ++count;
                    }
                }
            }
            this.populator.add(Collections.singletonList(updates.next()), CursorContext.NULL);
            ++count;
        }
        return count;
    }
}

