/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.neo4j.kernel.impl.index.schema.PhysicalToLogicalTokenChanges;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;

@Execution(value=ExecutionMode.CONCURRENT)
class PhysicalToLogicalTokenChangesTest {
    PhysicalToLogicalTokenChangesTest() {
    }

    @Test
    void shouldSeeSimpleAddition() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L));
    }

    @Test
    void shouldSeeSimpleRemoval() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]));
    }

    @Test
    void shouldSeeSomeAdded() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 5L), PhysicalToLogicalTokenChangesTest.ids(1L, 2L, 3L, 4L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L, 4L, 6L));
    }

    @Test
    void shouldSeeSomeRemoved() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 2L, 3L, 4L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 5L), PhysicalToLogicalTokenChangesTest.ids(2L, 4L, 6L), PhysicalToLogicalTokenChangesTest.ids(new long[0]));
    }

    @Test
    void shouldSeeSomeAddedAndSomeRemoved() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 4L, 6L), PhysicalToLogicalTokenChangesTest.ids(0L, 2L, 3L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(1L, 4L), PhysicalToLogicalTokenChangesTest.ids(0L, 2L, 5L));
    }

    private static void convertAndAssert(long[] before, long[] after, long[] expectedRemoved, long[] expectedAdded) {
        TokenIndexEntryUpdate update = TokenIndexEntryUpdate.change((long)0L, null, (long[])before, (long[])after);
        PhysicalToLogicalTokenChanges.convertToAdditionsAndRemovals((TokenIndexEntryUpdate)update);
        Assertions.assertArrayEquals((long[])PhysicalToLogicalTokenChangesTest.terminate(update.beforeValues()), (long[])expectedRemoved);
        Assertions.assertArrayEquals((long[])PhysicalToLogicalTokenChangesTest.terminate(update.values()), (long[])expectedAdded);
    }

    private static long[] terminate(long[] labels) {
        int length = PhysicalToLogicalTokenChangesTest.actualLength(labels);
        return length == labels.length ? labels : Arrays.copyOf(labels, length);
    }

    private static int actualLength(long[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] != -1L) continue;
            return i;
        }
        return labels.length;
    }

    private static long[] ids(long ... ids) {
        return ids;
    }
}

