/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexEntryResourceTypesTest {
    private static final int labelId = 1;
    private static final int propertyId = 2;
    private static final Value value = Values.of((Object)"value");

    @Test
    void shouldProduceBackwardsCompatibleId() {
        long id = ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)2, (Object)value)});
        Assertions.assertThat((long)id).isEqualTo(6676982443481287192L);
    }

    @Test
    void shouldDifferentiateBetweenIndexes() {
        PropertyIndexQuery.ExactPredicate pred1 = PropertyIndexQuery.exact((int)1, (Object)"value");
        PropertyIndexQuery.ExactPredicate pred2 = PropertyIndexQuery.exact((int)1, (Object)"value2");
        PropertyIndexQuery.ExactPredicate pred3 = PropertyIndexQuery.exact((int)2, (Object)"value");
        PropertyIndexQuery.ExactPredicate pred4 = PropertyIndexQuery.exact((int)2, (Object)"value2");
        List<Long> ids = Arrays.asList(ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred1}))), ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred2}))), ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred3}))), ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred4}))), ResourceIds.indexEntryResourceId((long)2L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred1}))), ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred1, pred2}))), ResourceIds.indexEntryResourceId((long)1L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred1, pred2, pred3}))), ResourceIds.indexEntryResourceId((long)2L, (PropertyIndexQuery.ExactPredicate[])((PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{pred1, pred2, pred3, pred4}))));
        Set uniqueIds = Iterables.asSet(ids);
        Assertions.assertThat((int)ids.size()).isEqualTo(uniqueIds.size());
    }

    @Test
    void mustBeAbleToHashAllTypesWith4xHashFunction() {
        IndexEntryResourceTypesTest.verifyCanHashAllTypes(ResourceIds::indexEntryResourceId_4_x);
    }

    private static void verifyCanHashAllTypes(IndexEntryHasher hasher) {
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)"")}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)"a")}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{""})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{"a"})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{"a", "b"})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)true)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[]{true})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[]{true, false})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)true)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[]{true})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[]{true, false})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[]{(byte)1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[]{(byte)1, (byte)2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[]{(short)1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[]{(short)1, (short)2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[]{'a'})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[]{'a', 'b'})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a')})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[]{1.0f})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[]{1.0f, 2.0f})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f)})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[]{1L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[]{1L, 2L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1L)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[]{1L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[]{1L, 2L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1.0)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[]{1.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[]{1.0, 2.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1.0)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[]{1.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[]{1.0, 2.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)""), PropertyIndexQuery.exact((int)-2, (Object)"")}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)"a"), PropertyIndexQuery.exact((int)-2, (Object)"a")}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[0]), PropertyIndexQuery.exact((int)-2, (Object)new String[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{""}), PropertyIndexQuery.exact((int)-2, (Object)new String[]{""})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{"a"}), PropertyIndexQuery.exact((int)-2, (Object)new String[]{"a"})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new String[]{"a", "b"}), PropertyIndexQuery.exact((int)-2, (Object)new String[]{"a", "b"})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)true), PropertyIndexQuery.exact((int)-2, (Object)true)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[0]), PropertyIndexQuery.exact((int)-2, (Object)new boolean[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[]{true}), PropertyIndexQuery.exact((int)-2, (Object)new boolean[]{true})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new boolean[]{true, false}), PropertyIndexQuery.exact((int)-2, (Object)new boolean[]{true, false})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)true), PropertyIndexQuery.exact((int)-2, (Object)true)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[0]), PropertyIndexQuery.exact((int)-2, (Object)new Boolean[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[]{true}), PropertyIndexQuery.exact((int)-2, (Object)new Boolean[]{true})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Boolean[]{true, false}), PropertyIndexQuery.exact((int)-2, (Object)new Boolean[]{true, false})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[0]), PropertyIndexQuery.exact((int)-2, (Object)new byte[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[]{1}), PropertyIndexQuery.exact((int)-2, (Object)new byte[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new byte[]{1, 2}), PropertyIndexQuery.exact((int)-2, (Object)new byte[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[0]), PropertyIndexQuery.exact((int)-2, (Object)new Byte[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[]{(byte)1}), PropertyIndexQuery.exact((int)-2, (Object)new Byte[]{(byte)1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Byte[]{(byte)1, (byte)2}), PropertyIndexQuery.exact((int)-2, (Object)new Byte[]{(byte)1, (byte)2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[0]), PropertyIndexQuery.exact((int)-2, (Object)new short[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[]{1}), PropertyIndexQuery.exact((int)-2, (Object)new short[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new short[]{1, 2}), PropertyIndexQuery.exact((int)-2, (Object)new short[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[0]), PropertyIndexQuery.exact((int)-2, (Object)new Short[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[]{(short)1}), PropertyIndexQuery.exact((int)-2, (Object)new Short[]{(short)1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Short[]{(short)1, (short)2}), PropertyIndexQuery.exact((int)-2, (Object)new Short[]{(short)1, (short)2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Character.valueOf('a')), PropertyIndexQuery.exact((int)-2, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[0]), PropertyIndexQuery.exact((int)-2, (Object)new char[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[]{'a'}), PropertyIndexQuery.exact((int)-2, (Object)new char[]{'a'})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new char[]{'a', 'b'}), PropertyIndexQuery.exact((int)-2, (Object)new char[]{'a', 'b'})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Character.valueOf('a')), PropertyIndexQuery.exact((int)-2, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[0]), PropertyIndexQuery.exact((int)-2, (Object)new Character[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a')}), PropertyIndexQuery.exact((int)-2, (Object)new Character[]{Character.valueOf('a')})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')}), PropertyIndexQuery.exact((int)-2, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Float.valueOf(1.0f)), PropertyIndexQuery.exact((int)-2, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[0]), PropertyIndexQuery.exact((int)-2, (Object)new float[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[]{1.0f}), PropertyIndexQuery.exact((int)-2, (Object)new float[]{1.0f})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new float[]{1.0f, 2.0f}), PropertyIndexQuery.exact((int)-2, (Object)new float[]{1.0f, 2.0f})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)Float.valueOf(1.0f)), PropertyIndexQuery.exact((int)-2, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[0]), PropertyIndexQuery.exact((int)-2, (Object)new Float[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f)}), PropertyIndexQuery.exact((int)-2, (Object)new Float[]{Float.valueOf(1.0f)})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}), PropertyIndexQuery.exact((int)-2, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[0]), PropertyIndexQuery.exact((int)-2, (Object)new int[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[]{1}), PropertyIndexQuery.exact((int)-2, (Object)new int[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new int[]{1, 2}), PropertyIndexQuery.exact((int)-2, (Object)new int[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[0]), PropertyIndexQuery.exact((int)-2, (Object)new Integer[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[]{1}), PropertyIndexQuery.exact((int)-2, (Object)new Integer[]{1})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Integer[]{1, 2}), PropertyIndexQuery.exact((int)-2, (Object)new Integer[]{1, 2})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1), PropertyIndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[0]), PropertyIndexQuery.exact((int)-2, (Object)new long[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[]{1L}), PropertyIndexQuery.exact((int)-2, (Object)new long[]{1L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new long[]{1L, 2L}), PropertyIndexQuery.exact((int)-2, (Object)new long[]{1L, 2L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1L), PropertyIndexQuery.exact((int)-2, (Object)1L)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[0]), PropertyIndexQuery.exact((int)-2, (Object)new Long[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[]{1L}), PropertyIndexQuery.exact((int)-2, (Object)new Long[]{1L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Long[]{1L, 2L}), PropertyIndexQuery.exact((int)-2, (Object)new Long[]{1L, 2L})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1.0), PropertyIndexQuery.exact((int)-2, (Object)1.0)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[0]), PropertyIndexQuery.exact((int)-2, (Object)new double[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[]{1.0}), PropertyIndexQuery.exact((int)-2, (Object)new double[]{1.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new double[]{1.0, 2.0}), PropertyIndexQuery.exact((int)-2, (Object)new double[]{1.0, 2.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)1.0), PropertyIndexQuery.exact((int)-2, (Object)1.0)}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[0]), PropertyIndexQuery.exact((int)-2, (Object)new Double[0])}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[]{1.0}), PropertyIndexQuery.exact((int)-2, (Object)new Double[]{1.0})}));
        hasher.hash(42L, (PropertyIndexQuery.ExactPredicate[])Iterators.array((Object[])new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)1, (Object)new Double[]{1.0, 2.0}), PropertyIndexQuery.exact((int)-2, (Object)new Double[]{1.0, 2.0})}));
    }

    private static interface IndexEntryHasher {
        public long hash(long var1, PropertyIndexQuery.ExactPredicate[] var3);
    }
}

