/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ReaderLogVersionBridgeTest {
    @Inject
    private TestDirectory testDirectory;
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogVersionedStoreChannel channel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
    private final long version = 10L;
    private LogFiles logFiles;

    ReaderLogVersionBridgeTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.logFiles = this.prepareLogFiles();
    }

    @Test
    void shouldOpenTheNextChannelWhenItExists() throws IOException {
        StoreChannel newStoreChannel = (StoreChannel)Mockito.mock(StoreChannel.class);
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles.getLogFile());
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.channel.getLogFormatVersion()).thenReturn((Object)7);
        Mockito.when((Object)this.fs.fileExists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.fs.read((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)newStoreChannel);
        Mockito.when((Object)newStoreChannel.read((ByteBuffer)ArgumentMatchers.any())).then((Answer)new Answer<Object>(){
            private int count;

            public Integer answer(InvocationOnMock invocation) {
                ++this.count;
                ByteBuffer buffer = (ByteBuffer)invocation.getArgument(0);
                if (this.count == 1) {
                    buffer.putLong(LogHeaderWriter.encodeLogVersion((long)11L, (long)7L));
                    return 8;
                }
                if (this.count == 2) {
                    buffer.putLong(42L);
                    buffer.putLong(1L);
                    buffer.putLong(2L);
                    buffer.putLong(3L);
                    buffer.putLong(4L);
                    buffer.putLong(5L);
                    buffer.putLong(0L);
                    return 56;
                }
                throw new AssertionError((Object)"Should only be called twice.");
            }
        });
        LogVersionedStoreChannel result = bridge.next(this.channel, false);
        PhysicalLogVersionedStoreChannel expected = new PhysicalLogVersionedStoreChannel(newStoreChannel, 11L, 7, Path.of("log.file", new String[0]), ChannelNativeAccessor.EMPTY_ACCESSOR);
        Assertions.assertEquals((Object)expected, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    void shouldReturnOldChannelWhenThereIsNoNextChannel() throws IOException {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles.getLogFile());
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.fs.read((Path)ArgumentMatchers.any(Path.class))).thenThrow(new Throwable[]{new NoSuchFileException("mock")});
        LogVersionedStoreChannel result = bridge.next(this.channel, false);
        Assertions.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void shouldReturnOldChannelWhenNextChannelHasNotGottenCompleteHeaderYet() throws Exception {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles.getLogFile());
        StoreChannel nextVersionWithIncompleteHeader = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)nextVersionWithIncompleteHeader.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)32);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.fs.fileExists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.fs.read((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)nextVersionWithIncompleteHeader);
        LogVersionedStoreChannel result = bridge.next(this.channel, false);
        Assertions.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }

    private LogFiles prepareLogFiles() throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.testDirectory.homePath(), (FileSystemAbstraction)this.fs).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).build();
    }
}

