/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class CheckPointThresholdDescriptionTest {
    CheckPointThresholdDescriptionTest() {
    }

    @Test
    void shouldCallConsumerProvidingTheDescriptionWhenThresholdIsTrue() {
        String description = "description";
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(true, description);
        AtomicReference calledWith = new AtomicReference();
        threshold.isCheckPointingNeeded(42L, 99L, calledWith::set);
        Assertions.assertEquals((Object)description, calledWith.get());
    }

    @Test
    void shouldNotCallConsumerProvidingTheDescriptionWhenThresholdIsFalse() {
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(false, null);
        Assertions.assertDoesNotThrow(() -> threshold.isCheckPointingNeeded(42L, 1L, s -> {
            throw new IllegalStateException("nooooooooo!");
        }));
    }

    private static class TheAbstractCheckPointThreshold
    extends AbstractCheckPointThreshold {
        private final boolean reached;

        TheAbstractCheckPointThreshold(boolean reached, String description) {
            super(description);
            this.reached = reached;
        }

        public void initialize(long transactionId) {
        }

        public void checkPointHappened(long transactionId) {
        }

        public long checkFrequencyMillis() {
            return DEFAULT_CHECKING_FREQUENCY_MILLIS;
        }

        protected boolean thresholdReached(long lastCommittedTransactionId, long lastCommittedTransactionLogVersion) {
            return this.reached;
        }
    }
}

