/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.function.IntPredicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipIndexedRelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class RelationshipIndexedRelationshipStoreScanTest {
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final TokenIndexReader relationshipTypeScanReader = (TokenIndexReader)Mockito.mock(TokenIndexReader.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final TokenScanConsumer typeScanConsumer = (TokenScanConsumer)Mockito.mock(TokenScanConsumer.class);
    private final PropertyScanConsumer propertyScanConsumer = (PropertyScanConsumer)Mockito.mock(PropertyScanConsumer.class);
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

    RelationshipIndexedRelationshipStoreScanTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void iterateOverRelationshipIds() {
        long highId = 15L;
        for (long i = 0L; i < highId; ++i) {
            this.cursors.withRelationship(i, 1L, 0, 1L);
        }
        int[] types = new int[]{1, 2};
        this.mockIdsReturnedFromTokenQueries();
        RelationshipIndexedRelationshipStoreScan storeScan = this.getRelationshipTypeScanViewStoreScan(types);
        EntityIdIterator idIterator = storeScan.getEntityIdIterator(CursorContext.NULL);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(1L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(2L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(4L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(5L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(6L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(8L);
        Assertions.assertThat((boolean)idIterator.hasNext()).isEqualTo(false);
    }

    private void mockIdsReturnedFromTokenQueries() {
        ((TokenIndexReader)Mockito.doAnswer(invocation -> {
            final IndexProgressor.EntityTokenClient client = (IndexProgressor.EntityTokenClient)invocation.getArgument(0);
            final TokenPredicate token = (TokenPredicate)invocation.getArgument(2);
            client.initialize(new IndexProgressor(){
                private final PrimitiveIterator.OfLong relationshipsWithType1 = Arrays.stream(new long[]{1L, 2L, 4L, 8L}).iterator();
                private final PrimitiveIterator.OfLong relationshipsWithType2 = Arrays.stream(new long[]{2L, 5L, 6L}).iterator();

                public boolean next() {
                    PrimitiveIterator.OfLong relationshipsWithType = this.relationshipsWithType1;
                    if (token.tokenId() == 2) {
                        relationshipsWithType = this.relationshipsWithType2;
                    }
                    if (relationshipsWithType.hasNext()) {
                        client.acceptEntity(relationshipsWithType.nextLong(), null);
                        return true;
                    }
                    return false;
                }

                public void close() {
                }
            }, token.tokenId(), IndexOrder.NONE);
            return null;
        }).when((Object)this.relationshipTypeScanReader)).query((IndexProgressor.EntityTokenClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (TokenPredicate)ArgumentMatchers.any(), (EntityRange)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any());
    }

    private RelationshipIndexedRelationshipStoreScan getRelationshipTypeScanViewStoreScan(int[] relationshipTypeIds) {
        return new RelationshipIndexedRelationshipStoreScan(Config.defaults(), (StorageReader)this.cursors, LockService.NO_LOCK_SERVICE, this.relationshipTypeScanReader, this.typeScanConsumer, this.propertyScanConsumer, relationshipTypeIds, this.propertyKeyIdFilter, false, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

