/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collector;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.HeapTrackingListValueBuilder;
import org.neo4j.values.virtual.ListValue;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingListValueBuilderTest {
    @Inject
    private RandomRule rnd;
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final HeapTrackingListValueBuilder listValueBuilder = HeapTrackingListValueBuilder.newHeapTrackingListBuilder((MemoryTracker)this.memoryTracker);

    HeapTrackingListValueBuilderTest() {
    }

    @AfterEach
    void tearDown() {
        this.listValueBuilder.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void addAndIterateElements() {
        int iterations = this.rnd.nextInt(10, 1000);
        for (int i = 0; i < iterations; ++i) {
            this.listValueBuilder.add((AnyValue)Values.longValue((long)i));
        }
        long memoryTrackerActualSize = this.meter.measureDeep((Object)this.memoryTracker);
        long actualBuilderSize = this.meter.measureDeep((Object)this.listValueBuilder) - memoryTrackerActualSize;
        long estimatedBuilderSize = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertEquals((long)actualBuilderSize, (long)estimatedBuilderSize);
        ListValue listValue = this.listValueBuilder.build();
        long actualValueSize = this.meter.measureDeep((Object)listValue) - memoryTrackerActualSize;
        long estimatedValueSize = listValue.estimatedHeapUsage();
        Assertions.assertEquals((long)actualValueSize, (long)estimatedValueSize);
        Iterator iterator = listValue.iterator();
        for (int i = 0; i < iterations; ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((long)i, (long)((LongValue)iterator.next()).longValue());
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void streamAndCollectElements() {
        int iterations = this.rnd.nextInt(10, 1000);
        ArrayList<LongValue> list = new ArrayList<LongValue>(iterations);
        for (int i = 0; i < iterations; ++i) {
            list.add(Values.longValue((long)i));
        }
        Collector collector = HeapTrackingListValueBuilder.collector((MemoryTracker)this.memoryTracker);
        ListValue listValue = (ListValue)list.stream().collect(collector);
        long memoryTrackerActualSize = this.meter.measureDeep((Object)this.memoryTracker);
        long actualValueSize = this.meter.measureDeep((Object)listValue) - memoryTrackerActualSize;
        long estimatedValueSize = listValue.estimatedHeapUsage();
        Assertions.assertEquals((long)actualValueSize, (long)estimatedValueSize);
        Iterator iterator = listValue.iterator();
        for (int i = 0; i < iterations; ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((long)i, (long)((LongValue)iterator.next()).longValue());
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

