/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.ProbeTable;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;

class ProbeTableTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final ProbeTable<LongValue, LongValue> table = ProbeTable.createProbeTable((MemoryTracker)this.memoryTracker);

    ProbeTableTest() {
    }

    @AfterEach
    void tearDown() {
        this.table.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void emptySize() {
        long actual = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actual, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void countInternalStructure() {
        this.table.put((Measurable)Values.longValue((long)0L), (Measurable)Values.longValue((long)2L));
        this.table.put((Measurable)Values.longValue((long)0L), (Measurable)Values.longValue((long)3L));
        this.table.put((Measurable)Values.longValue((long)1L), (Measurable)Values.longValue((long)4L));
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        Iterator iterator2 = this.table.get((Measurable)Values.longValue((long)0L));
        Assertions.assertTrue((boolean)iterator2.hasNext());
        Assertions.assertEquals((long)2L, (long)((LongValue)iterator2.next()).longValue());
        Assertions.assertTrue((boolean)iterator2.hasNext());
        Assertions.assertEquals((long)3L, (long)((LongValue)iterator2.next()).longValue());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = this.table.get((Measurable)Values.longValue((long)1L));
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((long)4L, (long)((LongValue)iterator3.next()).longValue());
        Assertions.assertFalse((boolean)iterator3.hasNext());
    }

    @Test
    void closeShouldReleaseEverything() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        this.table.put((Measurable)Values.longValue((long)0L), (Measurable)Values.longValue((long)2L));
        this.table.put((Measurable)Values.longValue((long)0L), (Measurable)Values.longValue((long)3L));
        this.table.put((Measurable)Values.longValue((long)1L), (Measurable)Values.longValue((long)4L));
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)(actualSize + externalAllocation), (long)this.memoryTracker.estimatedHeapMemory());
        this.table.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }
}

