/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScan;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexProgressor;
import org.neo4j.util.VisibleForTesting;

public class DefaultTokenIndexReader
implements TokenIndexReader {
    private final GBPTree<TokenScanKey, TokenScanValue> index;

    public DefaultTokenIndexReader(GBPTree<TokenScanKey, TokenScanValue> index) {
        this.index = index;
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) {
        this.query(client, constraints, query, EntityRange.FULL, cursorContext);
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, EntityRange range, CursorContext cursorContext) {
        try {
            int tokenId = query.tokenId();
            IndexOrder order = constraints.order();
            Seeker<TokenScanKey, TokenScanValue> seeker = this.seekerForToken(range, tokenId, order, cursorContext);
            TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(seeker, client, order, range);
            client.initialize((IndexProgressor)progressor, tokenId, order);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TokenScan entityTokenScan(int tokenId, CursorContext cursorContext) {
        try {
            long highestEntityIdForToken = this.highestEntityIdForToken(tokenId, cursorContext);
            return new NativeTokenScan(tokenId, highestEntityIdForToken);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long highestEntityIdForToken(int tokenId, CursorContext cursorContext) throws IOException {
        try (Seeker seeker = this.index.seek((Object)new TokenScanKey(tokenId, Long.MAX_VALUE), (Object)new TokenScanKey(tokenId, Long.MIN_VALUE), cursorContext);){
            long l = seeker.next() ? (((TokenScanKey)seeker.key()).idRange + 1L) * 64L : 0L;
            return l;
        }
    }

    private Seeker<TokenScanKey, TokenScanValue> seekerForToken(EntityRange range, int tokenId, IndexOrder indexOrder, CursorContext cursorContext) throws IOException {
        long rangeFrom = range.fromInclusive;
        long rangeTo = range.toExclusive;
        if (indexOrder == IndexOrder.DESCENDING) {
            long tmp = rangeFrom;
            rangeFrom = rangeTo;
            rangeTo = tmp;
        }
        TokenScanKey fromKey = new TokenScanKey(tokenId, TokenIndexUpdater.rangeOf(rangeFrom));
        TokenScanKey toKey = new TokenScanKey(tokenId, TokenIndexUpdater.rangeOf(rangeTo));
        return this.index.seek((Object)fromKey, (Object)toKey, cursorContext);
    }

    public void close() {
    }

    @VisibleForTesting
    static long roundUp(long sizeHint) {
        return (sizeHint + 64L - 1L) / 64L * 64L;
    }

    private class NativeTokenScan
    implements TokenScan {
        private final AtomicLong nextStart;
        private final int tokenId;
        private final long max;

        NativeTokenScan(int tokenId, long max) {
            this.tokenId = tokenId;
            this.max = max;
            this.nextStart = new AtomicLong(0L);
        }

        public IndexProgressor initialize(IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, CursorContext cursorContext) {
            return this.init(client, Long.MIN_VALUE, Long.MAX_VALUE, indexOrder, cursorContext);
        }

        public IndexProgressor initializeBatch(IndexProgressor.EntityTokenClient client, int sizeHint, CursorContext cursorContext) {
            if (sizeHint == 0) {
                return IndexProgressor.EMPTY;
            }
            long size = DefaultTokenIndexReader.roundUp(sizeHint);
            long start = this.nextStart.getAndAdd(size);
            long stop = Math.min(start + size, this.max);
            if (start >= this.max) {
                return IndexProgressor.EMPTY;
            }
            return this.init(client, start, stop, IndexOrder.NONE, cursorContext);
        }

        private IndexProgressor init(IndexProgressor.EntityTokenClient client, long start, long stop, IndexOrder indexOrder, CursorContext cursorContext) {
            Seeker<TokenScanKey, TokenScanValue> cursor;
            EntityRange range = new EntityRange(start, stop);
            try {
                cursor = DefaultTokenIndexReader.this.seekerForToken(range, this.tokenId, indexOrder, cursorContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new TokenScanValueIndexProgressor(cursor, client, indexOrder, range);
        }
    }
}

