/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.assertj.core.api.Assertions;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingIntObjectHashMapTest {
    private static final long INTEGER_SIZE = HeapEstimator.shallowSizeOfInstance(Integer.class);
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryPool memoryPool;
    private MemoryTracker memoryTracker;

    HeapTrackingIntObjectHashMapTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool);
    }

    @Test
    void calculateEmptySize() {
        HeapTrackingIntObjectHashMap intObjectHashMap = HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(intObjectHashMap);
        intObjectHashMap.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void reactToGrowth() {
        long totalBytesIntegers = 0L;
        HeapTrackingIntObjectHashMap intObjectHashMap = HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(intObjectHashMap);
        long emptySize = this.memoryTracker.estimatedHeapMemory();
        for (int i = 2; i <= 10; ++i) {
            totalBytesIntegers += INTEGER_SIZE;
            this.memoryTracker.allocateHeap(INTEGER_SIZE);
            intObjectHashMap.put(i, (Object)i);
        }
        this.assertExactEstimation(intObjectHashMap);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isGreaterThan(emptySize);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(this.memoryTracker.estimatedHeapMemory());
        intObjectHashMap.close();
        this.memoryTracker.releaseHeap(totalBytesIntegers);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
    }

    @Test
    void handleLargeArraysWithoutOverflowing() {
        Assertions.assertThat((long)HeapTrackingIntObjectHashMap.arraysHeapSize((int)0x20000000)).isGreaterThan(0L);
    }

    private void assertExactEstimation(HeapTrackingIntObjectHashMap<?> longObjectHashMap) {
        org.junit.jupiter.api.Assertions.assertEquals((long)(this.meter.measureDeep(longObjectHashMap) - this.meter.measureDeep((Object)this.memoryTracker)), (long)this.memoryTracker.estimatedHeapMemory());
    }
}

