/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingLongArrayListTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private HeapTrackingLongArrayList aList;
    private long[] longArray;
    @Inject
    private RandomRule random;

    HeapTrackingLongArrayListTest() {
    }

    @BeforeEach
    void setUp() {
        this.longArray = new long[100];
        for (int i = 0; i < this.longArray.length; ++i) {
            this.longArray[i] = i;
        }
        this.aList = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);
        this.aList.addAll(this.longArray);
    }

    @AfterEach
    void tearDown() {
        this.longArray = null;
        this.aList.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void initialSize() {
        try (HeapTrackingLongArrayList list = HeapTrackingLongArrayList.newLongArrayList((int)5, (MemoryTracker)this.memoryTracker);){
            Assertions.assertEquals((int)0, (int)list.size(), (String)"Should not contain any elements when created");
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> HeapTrackingLongArrayList.newLongArrayList((int)-10, (MemoryTracker)this.memoryTracker));
    }

    @Test
    void addObjectAtIndex() {
        long l = this.random.nextLong();
        this.aList.add(50, l);
        Assertions.assertEquals((long)this.aList.get(50), (long)l, (String)"Failed to add Object");
        Assertions.assertTrue((this.aList.get(51) == this.longArray[50] && this.aList.get(52) == this.longArray[51] ? 1 : 0) != 0, (String)"Failed to fix up list after insert");
        Long oldItem = this.aList.get(25);
        this.aList.add(25, -1L);
        Assertions.assertEquals((long)this.aList.get(25), (long)-1L, (String)"Should have returned null");
        Assertions.assertSame((Object)this.aList.get(26), (Object)oldItem, (String)"Should have returned the old item from slot 25");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.add(-1, -1L));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.add(this.aList.size() + 1, -1L));
    }

    @Test
    void addObjectLast() {
        long l = this.random.nextLong();
        this.aList.add(l);
        Assertions.assertEquals((long)this.aList.get(this.aList.size() - 1), (long)l, (String)"Failed to add long");
    }

    @Test
    void clear() {
        this.aList.clear();
        Assertions.assertEquals((int)0, (int)this.aList.size(), (String)"List did not clear");
        this.aList.add(this.random.nextLong());
        this.aList.add(this.random.nextLong());
        this.aList.add(this.random.nextLong());
        this.aList.add(this.random.nextLong());
        this.aList.clear();
        Assertions.assertEquals((int)0, (int)this.aList.size(), (String)"List with nulls did not clear");
    }

    @Test
    void get() {
        Assertions.assertSame((Object)this.aList.get(22), (Object)this.longArray[22], (String)"Returned incorrect element");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.get(8765));
    }

    @Test
    void isEmpty() {
        try (HeapTrackingLongArrayList list = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);){
            Assertions.assertTrue((boolean)list.isEmpty(), (String)"isEmpty returned false for new list");
        }
        Assertions.assertFalse((boolean)this.aList.isEmpty(), (String)"Returned true for existing list with elements");
    }

    @Test
    void setElement() {
        long l = this.random.nextLong();
        this.aList.set(65, l);
        Assertions.assertEquals((long)this.aList.get(65), (long)l, (String)"Failed to set object");
        Assertions.assertEquals((int)100, (int)this.aList.size(), (String)("Setting increased the list's size to: " + this.aList.size()));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.set(-1, this.random.nextLong()));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.set(this.aList.size() + 1, this.random.nextLong()));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)100, (int)this.aList.size(), (String)"Returned incorrect size for exiting list");
        try (HeapTrackingLongArrayList list = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);){
            Assertions.assertEquals((int)0, (int)list.size(), (String)"Returned incorrect size for new list");
        }
    }

    @Test
    void iterator() {
        PrimitiveLongResourceIterator iterator = this.aList.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assertions.assertTrue((i < this.longArray.length ? 1 : 0) != 0);
            Assertions.assertEquals((long)this.longArray[i++], (long)iterator.next());
        }
        Assertions.assertEquals((int)i, (int)this.longArray.length);
    }
}

