/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Callable;
import java.util.function.IntPredicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class, JobSchedulerExtension.class})
class MultipleIndexPopulatorTest {
    @Inject
    private RandomRule random;
    @Inject
    private JobScheduler jobScheduler;
    private final LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
    private IndexStoreView indexStoreView;
    private SchemaState schemaState;
    private MultipleIndexPopulator multipleIndexPopulator;
    private IndexStatisticsStore indexStatisticsStore;
    private InMemoryTokens tokens;

    MultipleIndexPopulatorTest() {
    }

    @BeforeEach
    void before() {
        this.indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
        this.indexStoreView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)this.indexStoreView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(CursorContext.class), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
        Mockito.when((Object)this.indexStoreView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((StoreScan)Mockito.mock(StoreScan.class)));
        this.schemaState = (SchemaState)Mockito.mock(SchemaState.class);
        this.tokens = new InMemoryTokens();
        this.multipleIndexPopulator = new MultipleIndexPopulator(this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.schemaState, this.jobScheduler, (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
    }

    @Test
    void disconnectedPopulationNotAbleToCreateNewIndex() throws FlipFailedKernelException, IOException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.disconnectAndStop(CursorContext.NULL);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).create();
    }

    @Test
    void disconnectedPopulationNotAbleToFlip() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.disconnectAndStop(CursorContext.NULL);
        indexPopulation.flip(false, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).sample(CursorContext.NULL);
    }

    @Test
    void flippedPopulationIsNotCloseable() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.flip(false, CursorContext.NULL);
        indexPopulation.disconnectAndStop(CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).close(false, CursorContext.NULL);
    }

    @Test
    void disconnectAndDropShouldCallDropOnPopulator() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.disconnectAndDrop();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).close(false, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator)).drop();
    }

    @Test
    void testMultiplePopulatorsCreation() throws FlipFailedKernelException, IOException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    void testMultiplePopulatorCreationFailure() throws FlipFailedKernelException, IOException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator3 = MultipleIndexPopulatorTest.createIndexPopulator();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator3)).create();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.addPopulator(indexPopulator3, 3);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator3);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    void testHasPopulators() throws FlipFailedKernelException {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
        this.addPopulator(MultipleIndexPopulatorTest.createIndexPopulator(), 42);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void stoppingSinglePopulatorDoNotStopAnyOther() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        MultipleIndexPopulator.IndexPopulation populationToKeepActive = this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.stop(populationToCancel, CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        ((FlippableIndexProxy)Mockito.verify((Object)populationToKeepActive.flipper)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void stoppedPopulatorDoNotFlipWhenPopulationCompleted() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.stop(populationToCancel, CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        ((FlippableIndexProxy)Mockito.verify((Object)populationToCancel.flipper, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void testIndexAllNodes() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (PropertyScanConsumer)ArgumentMatchers.any(PropertyScanConsumer.class), (TokenScanConsumer)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(PageCacheTracer.class), (MemoryTracker)ArgumentMatchers.any());
    }

    @Test
    void testCancelPopulator() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.cancel((Throwable)MultipleIndexPopulatorTest.getPopulatorException(), CursorContext.NULL);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    void testCancelByPopulation() throws FlipFailedKernelException {
        IndexPopulator populator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator populator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.cancel(population2, (Throwable)MultipleIndexPopulatorTest.getPopulatorException(), CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator1, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator2);
    }

    @Test
    void testCancelByPopulationRemovesPopulator() throws FlipFailedKernelException {
        IndexPopulator populator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator populator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation population1 = this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.cancel(population1, (Throwable)MultipleIndexPopulatorTest.getPopulatorException(), CursorContext.NULL);
        this.multipleIndexPopulator.cancel(population2, (Throwable)MultipleIndexPopulatorTest.getPopulatorException(), CursorContext.NULL);
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void testCancelByNonExistingPopulation() throws FlipFailedKernelException {
        MultipleIndexPopulator.IndexPopulation nonExistingPopulation = (MultipleIndexPopulator.IndexPopulation)Mockito.mock(MultipleIndexPopulator.IndexPopulation.class);
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(populator, 1);
        this.multipleIndexPopulator.cancel(nonExistingPopulation, (Throwable)MultipleIndexPopulatorTest.getPopulatorException(), CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
    }

    @Test
    void testFlipAfterStoreScan() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        FlippableIndexProxy flipper1 = this.addPopulator((IndexPopulator)indexPopulator1, (int)1).flipper;
        FlippableIndexProxy flipper2 = this.addPopulator((IndexPopulator)indexPopulator2, (int)2).flipper;
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        ((FlippableIndexProxy)Mockito.verify((Object)flipper1)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        ((FlippableIndexProxy)Mockito.verify((Object)flipper2)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void populationsRemovedDuringFlip() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void testStopPopulation() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.stop(CursorContext.NULL);
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore, (VerificationMode)Mockito.times((int)2))).replaceStats(ArgumentMatchers.anyLong(), (IndexSample)ArgumentMatchers.eq((Object)new IndexSample(0L, 0L, 0L)));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(false, CursorContext.NULL);
    }

    @Test
    void testIndexFlip() {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1, flipper, failedIndexProxyFactory);
        this.addPopulator(indexPopulator2, 2, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator1.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenThrow(new Throwable[]{MultipleIndexPopulatorTest.getSampleError()});
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false, CursorContext.NULL);
        ((FailedIndexProxyFactory)Mockito.verify((Object)failedIndexProxyFactory)).create((Throwable)ArgumentMatchers.any(RuntimeException.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(true, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).sample(CursorContext.NULL);
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).replaceStats(ArgumentMatchers.anyLong(), (IndexSample)ArgumentMatchers.any());
        ((SchemaState)Mockito.verify((Object)this.schemaState)).clear();
    }

    @Test
    void testMultiplePopulatorUpdater() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator2)).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class), (CursorContext)ArgumentMatchers.any());
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class), CursorContext.NULL);
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator2);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).process(propertyUpdate);
    }

    @Test
    void testNonApplicableUpdaterDoNotUpdatePopulator() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 2);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class), CursorContext.NULL);
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        Mockito.verifyNoInteractions((Object[])new Object[]{indexUpdater1});
    }

    @Test
    void testPropertyUpdateFailure() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexUpdater1)).process(propertyUpdate);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class), CursorContext.NULL);
        multipleIndexUpdater.process(propertyUpdate);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).close();
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
    }

    @Test
    void testMultiplePropertyUpdateFailures() throws IndexEntryConflictException, FlipFailedKernelException {
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        ValueIndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.index1, (Object[])new Object[]{"foo"});
        ValueIndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.index1, (Object[])new Object[]{"bar"});
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator(updater);
        this.addPopulator(populator, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)updater)).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater(nodePropertyAccessor, CursorContext.NULL);
        multipleIndexUpdater.process((IndexEntryUpdate)update1);
        multipleIndexUpdater.process((IndexEntryUpdate)update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).process((IndexEntryUpdate)update1);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).close();
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator);
    }

    @Test
    void shouldVerifyConstraintsBeforeFlippingIfToldTo() throws IndexEntryConflictException {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator, 1, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)new IndexSample());
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        this.multipleIndexPopulator.flipAfterStoreScan(true, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator)).close(true, CursorContext.NULL);
    }

    @Test
    void shouldIncludeIndexSampleUpdatesInStatsOnFlip() {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator, 1, flipper, failedIndexProxyFactory);
        int indexSize = 100;
        int uniqueValues = 110;
        int sampleSize = 120;
        int updates = 130;
        IndexSample sample = new IndexSample((long)indexSize, (long)uniqueValues, (long)sampleSize, (long)updates);
        Mockito.when((Object)indexPopulator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)sample);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        this.multipleIndexPopulator.flipAfterStoreScan(false, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator)).close(true, CursorContext.NULL);
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).replaceStats(1L, sample);
        ((SchemaState)Mockito.verify((Object)this.schemaState)).clear();
    }

    @Test
    void shouldApplyConcurrentUpdatesEarlierWhenHittingMaxBatchByteSize() {
        MultipleIndexPopulatorTest.createIndexPopulator();
        this.multipleIndexPopulator.create(CursorContext.NULL);
        String largeString = this.random.nextAlphaNumericString(100000, 100000);
        int roughlyNumUpdates = (int)((long)this.multipleIndexPopulator.batchMaxByteSizeScan / HeapEstimator.sizeOf((String)largeString));
        TextValue largeStringValue = Values.stringValue((String)largeString);
        IndexDescriptor indexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})).withName("name").materialise(99L);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL);
        boolean full = false;
        for (int i = 0; !full && i < roughlyNumUpdates * 2; ++i) {
            ValueIndexEntryUpdate largeUpdate = IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{largeStringValue});
            this.multipleIndexPopulator.queueConcurrentUpdate((IndexEntryUpdate)largeUpdate);
            full = this.multipleIndexPopulator.needToApplyExternalUpdates();
            if (!full) continue;
            this.multipleIndexPopulator.applyExternalUpdates(Long.MAX_VALUE);
        }
        Assertions.assertThat((boolean)full).isTrue();
    }

    @Test
    void updateForHigherNodeIgnoredWhenUsingFullNodeStoreScan() throws IndexEntryConflictException, FlipFailedKernelException {
        MultipleIndexPopulatorTest.createIndexPopulator();
        this.multipleIndexPopulator.create(CursorContext.NULL);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator(updater);
        IndexUpdater indexUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        this.addPopulator(populator, 1);
        ValueIndexEntryUpdate lowUpdate = IndexEntryUpdate.add((long)10L, (SchemaDescriptorSupplier)schema, (Value[])new Value[]{Values.intValue((int)99)});
        ValueIndexEntryUpdate highUpdate = IndexEntryUpdate.add((long)20L, (SchemaDescriptorSupplier)schema, (Value[])new Value[]{Values.intValue((int)101)});
        this.multipleIndexPopulator.queueConcurrentUpdate((IndexEntryUpdate)lowUpdate);
        this.multipleIndexPopulator.queueConcurrentUpdate((IndexEntryUpdate)highUpdate);
        this.multipleIndexPopulator.applyExternalUpdates(15L);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)1))).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any());
        ((IndexUpdater)Mockito.verify((Object)updater)).process((IndexEntryUpdate)lowUpdate);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)highUpdate);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
    }

    private static IndexEntryUpdate<?> createIndexEntryUpdate(LabelSchemaDescriptor schemaDescriptor) {
        return IndexQueryHelper.add((long)1L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"theValue"});
    }

    private static RuntimeException getSampleError() {
        return new RuntimeException("sample error");
    }

    private static IndexPopulator createIndexPopulator(IndexUpdater indexUpdater) {
        IndexPopulator indexPopulator = MultipleIndexPopulatorTest.createIndexPopulator();
        Mockito.when((Object)indexPopulator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)indexUpdater);
        return indexPopulator;
    }

    private static IndexPopulator createIndexPopulator() {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)populator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)new IndexSample());
        return populator;
    }

    private static UncheckedIOException getPopulatorException() {
        return new UncheckedIOException(new IOException("something went wrong"));
    }

    private static void checkPopulatorFailure(IndexPopulator populator) {
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)"something went wrong"));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(false, CursorContext.NULL);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return this.addPopulator(this.multipleIndexPopulator, indexPopulator, id, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)id, (int[])new int[]{id})).withName("index_" + id).materialise((long)id);
        return this.addPopulator(multipleIndexPopulator, descriptor, indexPopulator, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        ValueIndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(descriptor, this.indexStatisticsStore, (TokenNameLookup)this.tokens);
        return multipleIndexPopulator.addPopulator(indexPopulator, (IndexProxyStrategy)indexProxyStrategy, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id) throws FlipFailedKernelException {
        FlippableIndexProxy indexProxy = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        ((FlippableIndexProxy)Mockito.doAnswer(invocation -> {
            Callable argument = (Callable)invocation.getArgument(0);
            return argument.call();
        }).when((Object)indexProxy)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        return this.addPopulator(indexPopulator, id, indexProxy, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }
}

