/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RawBytes;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.ListBasedBlockEntryCursor;
import org.neo4j.test.rule.RandomRule;

class BlockEntryMergerTestUtils {
    BlockEntryMergerTestUtils() {
    }

    static <KEY, VALUE> void assertMergedPartStream(List<BlockEntry<KEY, VALUE>> expectedData, BlockEntryCursor<KEY, VALUE> actual) throws IOException {
        Iterator<BlockEntry<KEY, VALUE>> expected = expectedData.iterator();
        while (actual.next()) {
            Assertions.assertThat(expected).hasNext();
            BlockEntry<KEY, VALUE> expectedEntry = expected.next();
            Assertions.assertThat((Object)actual.key()).isEqualTo(expectedEntry.key());
            Assertions.assertThat((Object)actual.value()).isEqualTo(expectedEntry.value());
        }
        Assertions.assertThat((boolean)expected.hasNext()).isFalse();
    }

    static List<BlockEntryCursor<RawBytes, RawBytes>> buildParts(RandomRule random, Layout<RawBytes, RawBytes> layout, List<BlockEntry<RawBytes, RawBytes>> allData) {
        return BlockEntryMergerTestUtils.buildParts(random, layout, allData, random.nextInt(1, 12), rng -> rng.nextInt(1, 1000));
    }

    static List<BlockEntryCursor<RawBytes, RawBytes>> buildParts(RandomRule random, Layout<RawBytes, RawBytes> layout, List<BlockEntry<RawBytes, RawBytes>> allData, int numParts, ToIntFunction<RandomRule> partSize) {
        ArrayList<BlockEntryCursor<RawBytes, RawBytes>> parts = new ArrayList<BlockEntryCursor<RawBytes, RawBytes>>();
        for (int i = 0; i < numParts; ++i) {
            List<BlockEntry<RawBytes, RawBytes>> partData = BlockEntryMergerTestUtils.buildPart(random, layout, partSize.applyAsInt(random));
            allData.addAll(partData);
            parts.add((BlockEntryCursor<RawBytes, RawBytes>)new ListBasedBlockEntryCursor(partData));
        }
        BlockEntryMergerTestUtils.sort(allData, layout);
        return parts;
    }

    static List<BlockEntry<RawBytes, RawBytes>> buildPart(RandomRule random, Layout<RawBytes, RawBytes> layout, int count) {
        ArrayList<BlockEntry<RawBytes, RawBytes>> entries = new ArrayList<BlockEntry<RawBytes, RawBytes>>();
        for (int i = 0; i < count; ++i) {
            entries.add((BlockEntry<RawBytes, RawBytes>)new BlockEntry((Object)BlockEntryMergerTestUtils.randomBytesInstance(random), (Object)BlockEntryMergerTestUtils.randomBytesInstance(random)));
        }
        BlockEntryMergerTestUtils.sort(entries, layout);
        return entries;
    }

    private static RawBytes randomBytesInstance(RandomRule random) {
        return new RawBytes(random.nextBytes(new byte[8]));
    }

    private static void sort(List<BlockEntry<RawBytes, RawBytes>> entries, Layout<RawBytes, RawBytes> layout) {
        entries.sort((b1, b2) -> layout.compare((Object)((RawBytes)b1.key()), (Object)((RawBytes)b2.key())));
    }
}

