/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.ResultCursor;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

@ExtendWith(value={RandomExtension.class})
class FilteringNativeHitIndexProgressorTest {
    @Inject
    private RandomRule random;

    FilteringNativeHitIndexProgressorTest() {
    }

    @Test
    void shouldFilterResults() {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            keys.add(this.random.nextString());
        }
        ResultCursor cursor = new ResultCursor(keys.iterator());
        NodeValueIterator valueClient = new NodeValueIterator(){

            public boolean needsValues() {
                return true;
            }
        };
        PropertyIndexQuery[] predicates = new PropertyIndexQuery[]{(PropertyIndexQuery)Mockito.mock(PropertyIndexQuery.class)};
        Predicate<String> filter = string -> string.contains("a");
        Mockito.when((Object)predicates[0].acceptsValue((Value)ArgumentMatchers.any(Value.class))).then(invocation -> filter.test(((TextValue)invocation.getArgument(0)).stringValue()));
        try (FilteringNativeHitIndexProgressor progressor = new FilteringNativeHitIndexProgressor((Seeker)cursor, (IndexProgressor.EntityValueClient)valueClient, predicates);){
            valueClient.initialize(TestIndexDescriptorFactory.forLabel(0, 0), (IndexProgressor)progressor, predicates, IndexQueryConstraints.unorderedValues(), false);
            ArrayList<Long> result = new ArrayList<Long>();
            while (valueClient.hasNext()) {
                result.add(valueClient.next());
            }
            for (int i = 0; i < keys.size(); ++i) {
                if (!filter.test((String)keys.get(i))) continue;
                Assertions.assertTrue((boolean)result.remove((Object)i));
            }
            Assertions.assertTrue((boolean)result.isEmpty());
        }
    }
}

