/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RawBytes;
import org.neo4j.index.internal.gbptree.SimpleByteArrayLayout;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntryMergerTestUtils;
import org.neo4j.kernel.impl.index.schema.BlockEntryStreamMerger;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.PartMerger;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@ExtendWith(value={RandomExtension.class})
class PartMergerTest {
    @Inject
    private RandomRule random;
    private JobScheduler scheduler;
    private IndexPopulator.PopulationWorkScheduler populationWorkScheduler;

    PartMergerTest() {
    }

    @BeforeEach
    void setUp() {
        this.scheduler = new ThreadPoolJobScheduler();
        this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return PartMergerTest.this.scheduler.schedule(Group.INDEX_POPULATION_WORK, JobMonitoringParams.NOT_MONITORED, job);
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.scheduler.close();
    }

    @Test
    void shouldMergeParts() throws IOException {
        SimpleByteArrayLayout layout = new SimpleByteArrayLayout();
        ArrayList allData = new ArrayList();
        List<BlockEntryCursor<RawBytes, RawBytes>> parts = BlockEntryMergerTestUtils.buildParts(this.random, (Layout<RawBytes, RawBytes>)layout, allData);
        PartMerger merger = new PartMerger(this.populationWorkScheduler, parts, (Layout)layout, null, BlockStorage.Cancellation.NOT_CANCELLABLE, 10);
        try (BlockEntryStreamMerger stream = merger.startMerge();){
            BlockEntryMergerTestUtils.assertMergedPartStream(allData, stream);
        }
    }

    @Test
    void shouldMergeZeroParts() throws IOException {
        SimpleByteArrayLayout layout = new SimpleByteArrayLayout();
        PartMerger merger = new PartMerger(this.populationWorkScheduler, Collections.emptyList(), (Layout)layout, null, BlockStorage.Cancellation.NOT_CANCELLABLE, 10);
        try (BlockEntryStreamMerger stream = merger.startMerge();){
            Assertions.assertThat((boolean)stream.next()).isFalse();
        }
    }
}

