/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ThrowingConflictDetectorTest {
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private final ThrowingConflictDetector<GenericKey, NativeIndexValue> detector = new ThrowingConflictDetector(true);

    ThrowingConflictDetectorTest() {
    }

    @Test
    void shouldReportConflictOnSameValueAndDifferentEntityIds() {
        Value value = Values.of((Object)123);
        long entityId1 = 10L;
        long entityId2 = 20L;
        ValueMerger.MergeResult mergeResult = this.detector.merge((NativeIndexKey)ThrowingConflictDetectorTest.key(entityId1, value), (NativeIndexKey)ThrowingConflictDetectorTest.key(entityId2, value), NativeIndexValue.INSTANCE, NativeIndexValue.INSTANCE);
        Assertions.assertSame((Object)ValueMerger.MergeResult.UNCHANGED, (Object)mergeResult);
        IndexEntryConflictException e = (IndexEntryConflictException)Assertions.assertThrows(IndexEntryConflictException.class, () -> this.detector.checkConflict((Object)((Value[])ArrayUtil.array((Object[])new Value[]{value}))));
        Assertions.assertEquals((long)entityId1, (long)e.getExistingNodeId());
        Assertions.assertEquals((long)entityId2, (long)e.getAddedNodeId());
        Assertions.assertEquals((Object)value, (Object)e.getSinglePropertyValue());
    }

    @Test
    void shouldNotReportConflictOnSameValueSameEntityId() throws IndexEntryConflictException {
        Value value = Values.of((Object)123);
        long entityId = 10L;
        ValueMerger.MergeResult mergeResult = this.detector.merge((NativeIndexKey)ThrowingConflictDetectorTest.key(entityId, value), (NativeIndexKey)ThrowingConflictDetectorTest.key(entityId, value), NativeIndexValue.INSTANCE, NativeIndexValue.INSTANCE);
        Assertions.assertSame((Object)ValueMerger.MergeResult.UNCHANGED, (Object)mergeResult);
        this.detector.checkConflict((Object)((Value[])ArrayUtil.array((Object[])new Value[0])));
    }

    private static GenericKey key(long entityId, Value value) {
        GenericKey key = new GenericKey(specificSettings);
        key.initialize(entityId);
        key.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
        return key;
    }
}

