/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class LockReentrancyCompatibility
extends LockCompatibilityTestSupport {
    LockReentrancyCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void shouldAcquireExclusiveIfClientIsOnlyOneHoldingShared() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void shouldRetainExclusiveLockAfterReleasingSharedLock() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void shouldRetainSharedLockWhenAcquiredAfterExclusiveLock() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void sharedLocksShouldStack() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void exclusiveLocksShouldBeReentrantAndBlockOtherExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void exclusiveLocksShouldBeReentrantAndBlockOtherSharedLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
        Future<Void> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void sharedLocksShouldNotReplaceExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Void> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(clientBLock);
    }

    @Test
    void shouldUpgradeAndDowngradeSameSharedLock() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockIdentityExplorer sharedLockExplorer = new LockIdentityExplorer((ResourceType)ResourceTypes.NODE, 1L);
        this.locks.accept((Locks.Visitor)sharedLockExplorer);
        Future<Void> exclusiveLockFuture = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockReentrancyCompatibility.assertNotWaiting(exclusiveLockFuture);
        this.clientB.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        LockIdentityExplorer releasedLockExplorer = new LockIdentityExplorer((ResourceType)ResourceTypes.NODE, 1L);
        this.locks.accept((Locks.Visitor)releasedLockExplorer);
        Assertions.assertEquals((long)sharedLockExplorer.getLockIdentityHashCode(), (long)releasedLockExplorer.getLockIdentityHashCode());
    }

    private static class LockIdentityExplorer
    implements Locks.Visitor {
        private final ResourceType resourceType;
        private final long resourceId;
        private long lockIdentityHashCode;

        LockIdentityExplorer(ResourceType resourceType, long resourceId) {
            this.resourceType = resourceType;
            this.resourceId = resourceId;
        }

        public void visit(LockType lockType, ResourceType resourceType, long transactionId, long resourceId, String description, long estimatedWaitTime, long lockIdentityHashCode) {
            if (this.resourceType.equals(resourceType) && this.resourceId == resourceId) {
                this.lockIdentityHashCode = lockIdentityHashCode;
            }
        }

        public long getLockIdentityHashCode() {
            return this.lockIdentityHashCode;
        }
    }
}

