/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.scheduler.FailedJobRunsStore;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.time.Clocks;

class ThreadPoolManagerTest {
    ThreadPoolManagerTest() {
    }

    @Test
    void shouldDefaultToGroupParallelism() throws ExecutionException, InterruptedException {
        ThreadPoolManager manager = new ThreadPoolManager(new ThreadGroup("parent"), Clocks.nanoClock(), new FailedJobRunsStore(0), () -> 1L);
        AtomicBoolean hasBeenRun = new AtomicBoolean();
        ThreadPool pool = manager.getThreadPool(Group.PAGE_CACHE_PRE_FETCHER, null);
        JobHandle handle = pool.submit(JobMonitoringParams.NOT_MONITORED, () -> hasBeenRun.set(true));
        handle.waitTermination();
        Assertions.assertThat((boolean)hasBeenRun.get()).isTrue();
    }
}

